/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;

public class MapDeserializer<T extends Map<?, ?>>
extends AbstractContainerDeserializer<T>
implements EmbeddedItem {
    private final Type mapValueRuntimeType = this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[1]) : Object.class;
    private final T instance;

    protected MapDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.instance = this.createInstance(builder);
    }

    private T createInstance(DeserializerBuilder builder) {
        Class<?> rawType = ReflectionUtils.getRawType(this.getRuntimeType());
        return (T)(rawType.isInterface() ? this.getMapImpl(rawType, builder) : (Map)builder.getJsonbContext().getInstanceCreator().createInstance(rawType));
    }

    private Map getMapImpl(Class ifcType, DeserializerBuilder builder) {
        if (SortedMap.class.isAssignableFrom(ifcType)) {
            Class<?> defaultMapImplType = builder.getJsonbContext().getConfigProperties().getDefaultMapImplType();
            return SortedMap.class.isAssignableFrom(defaultMapImplType) ? (Map)builder.getJsonbContext().getInstanceCreator().createInstance(defaultMapImplType) : new TreeMap();
        }
        return new HashMap();
    }

    @Override
    public T getInstance(Unmarshaller unmarshaller) {
        return this.instance;
    }

    @Override
    public void appendResult(Object result) {
        this.appendCaptor(this.parserContext.getLastKeyName(), this.convertNullToOptionalEmpty(this.mapValueRuntimeType, result));
    }

    private <V> void appendCaptor(String key, V value) {
        this.getInstance(null).put(key, value);
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        JsonbDeserializer<?> deserializer = this.newCollectionOrMapItem(this.mapValueRuntimeType, context.getJsonbContext());
        this.appendResult(deserializer.deserialize(parser, context, this.mapValueRuntimeType));
    }

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_OBJECT);
        return parser.getCurrentLevel();
    }
}

