/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.management;

import java.util.List;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.management.ExecutionListener;

public final class ExecutionEvent {
    private final Object impl;

    ExecutionEvent(Object impl) {
        this.impl = impl;
    }

    public SourceSection getLocation() {
        return ExecutionListener.IMPL.getLocation(this.impl);
    }

    public String getRootName() {
        return ExecutionListener.IMPL.getRootName(this.impl);
    }

    public List<Value> getInputValues() {
        return ExecutionListener.IMPL.getInputValues(this.impl);
    }

    public Value getReturnValue() {
        return ExecutionListener.IMPL.getReturnValue(this.impl);
    }

    public PolyglotException getException() {
        return ExecutionListener.IMPL.getException(this.impl);
    }

    public boolean isExpression() {
        return ExecutionListener.IMPL.isExpression(this.impl);
    }

    public boolean isStatement() {
        return ExecutionListener.IMPL.isStatement(this.impl);
    }

    public boolean isRoot() {
        return ExecutionListener.IMPL.isRoot(this.impl);
    }

    public String toString() {
        PolyglotException exception;
        Value returnValue;
        List<Value> inputValues;
        String rootName;
        StringBuilder b = new StringBuilder("ExecutionEvent[");
        if (this.isRoot()) {
            b.append("root").append(", ");
        }
        if (this.isStatement()) {
            b.append("statement").append(", ");
        }
        if (this.isExpression()) {
            b.append("expression").append(", ");
        }
        if ((rootName = this.getRootName()) != null) {
            b.append("rootName=").append(rootName).append(", ");
        }
        if ((inputValues = this.getInputValues()) != null) {
            b.append("inputValues=").append(inputValues).append(", ");
        }
        if ((returnValue = this.getReturnValue()) != null) {
            b.append("returnValue=").append(returnValue).append(", ");
        }
        if ((exception = this.getException()) != null) {
            b.append("exception=").append(exception).append(", ");
        }
        b.append("location=").append(this.getLocation());
        b.append("]");
        return b.toString();
    }
}

