/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;

public final class StandardConversions {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static Object convertTextToText(Object source, MediaType sourceType, MediaType destinationType) {
        Charset destinationCharset;
        if (source == null) {
            return null;
        }
        if (sourceType == null) {
            throw new NullPointerException("MediaType cannot be null!");
        }
        if (!sourceType.match(MediaType.TEXT_PLAIN)) {
            throw Log.CONTAINER.invalidMediaType("text/plain", sourceType.toString());
        }
        boolean asString = destinationType.hasStringType();
        Charset sourceCharset = sourceType.getCharset();
        if (sourceCharset.equals(destinationCharset = destinationType.getCharset())) {
            return StandardConversions.convertTextClass(source, destinationType, asString);
        }
        byte[] byteContent = source instanceof byte[] ? (byte[])source : source.toString().getBytes(sourceCharset);
        return StandardConversions.convertTextClass(StandardConversions.convertCharset(byteContent, sourceCharset, destinationCharset), destinationType, asString);
    }

    private static Object convertTextClass(Object text, MediaType destination, boolean asString) {
        if (asString) {
            return text instanceof byte[] ? new String((byte[])text, destination.getCharset()) : text.toString();
        }
        return text instanceof byte[] ? text : (Object)text.toString().getBytes(destination.getCharset());
    }

    public static byte[] convertTextToOctetStream(Object source, MediaType sourceType) {
        if (source == null) {
            return null;
        }
        if (sourceType == null) {
            throw new NullPointerException("MediaType cannot be null!");
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        return source.toString().getBytes(sourceType.getCharset());
    }

    public static String convertTextToObject(Object source, MediaType sourceType) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            return source.toString();
        }
        if (source instanceof byte[]) {
            byte[] bytesSource = (byte[])source;
            return new String(bytesSource, sourceType.getCharset());
        }
        throw Log.CONTAINER.invalidTextContent(source);
    }

    public static String convertTextToUrlEncoded(Object source, MediaType sourceType) {
        return StandardConversions.urlEncode(source, sourceType);
    }

    public static byte[] convertOctetStreamToText(byte[] source, MediaType destination) {
        if (source == null) {
            return null;
        }
        return StandardConversions.convertCharset(source, StandardCharsets.UTF_8, destination.getCharset());
    }

    public static Object convertOctetStreamToJava(byte[] source, MediaType destination, Marshaller marshaller) {
        if (source == null) {
            return null;
        }
        if (!destination.match(MediaType.APPLICATION_OBJECT)) {
            throw Log.CONTAINER.invalidMediaType("application/x-java-object", destination.toString());
        }
        String classType = destination.getClassType();
        if (classType == null) {
            return source;
        }
        if (classType.equals("ByteArray")) {
            return source;
        }
        if (destination.hasStringType()) {
            return new String(source, StandardCharsets.UTF_8);
        }
        try {
            return marshaller.objectFromByteBuffer(source);
        }
        catch (IOException | ClassNotFoundException | IllegalStateException e) {
            throw Log.CONTAINER.conversionNotSupported(source, "application/octet-stream", destination.toString());
        }
    }

    public static byte[] convertJavaToOctetStream(Object source, MediaType sourceMediaType, Marshaller marshaller) throws IOException, InterruptedException {
        if (source == null) {
            return null;
        }
        if (!sourceMediaType.match(MediaType.APPLICATION_OBJECT)) {
            throw new EncodingException("sourceMediaType not conforming to application/x-java-object!");
        }
        Object decoded = StandardConversions.decodeObjectContent(source, sourceMediaType);
        if (decoded instanceof byte[]) {
            return (byte[])decoded;
        }
        if (decoded instanceof String && StandardConversions.isJavaString(sourceMediaType)) {
            return ((String)decoded).getBytes(StandardCharsets.UTF_8);
        }
        return marshaller.objectToByteBuffer(source);
    }

    public static byte[] convertJavaToProtoStream(Object source, MediaType sourceMediaType, ImmutableSerializationContext ctx) throws IOException, InterruptedException {
        if (source == null) {
            return null;
        }
        if (!sourceMediaType.match(MediaType.APPLICATION_OBJECT)) {
            throw new EncodingException("sourceMediaType not conforming to application/x-java-object!");
        }
        Object decoded = StandardConversions.decodeObjectContent(source, sourceMediaType);
        if (decoded instanceof byte[]) {
            return (byte[])decoded;
        }
        if (decoded instanceof String && StandardConversions.isJavaString(sourceMediaType)) {
            return ((String)decoded).getBytes(StandardCharsets.UTF_8);
        }
        return ProtobufUtil.toWrappedByteArray(ctx, source);
    }

    private static boolean isJavaString(MediaType mediaType) {
        return mediaType.match(MediaType.APPLICATION_OBJECT) && mediaType.hasStringType();
    }

    public static byte[] convertJavaToText(Object source, MediaType sourceMediaType, MediaType destinationMediaType) {
        if (source == null) {
            return null;
        }
        if (sourceMediaType == null || destinationMediaType == null) {
            throw new NullPointerException("sourceMediaType and destinationMediaType cannot be null!");
        }
        Object decoded = StandardConversions.decodeObjectContent(source, sourceMediaType);
        if (decoded instanceof byte[]) {
            return StandardConversions.convertCharset(source, StandardCharsets.UTF_8, destinationMediaType.getCharset());
        }
        String asString = decoded.toString();
        return asString.getBytes(destinationMediaType.getCharset());
    }

    public static Object decodeObjectContent(Object content, MediaType contentMediaType) {
        if (content == null) {
            return null;
        }
        if (contentMediaType == null) {
            throw new NullPointerException("contentMediaType cannot be null!");
        }
        String type = contentMediaType.getClassType();
        if (type == null) {
            return content;
        }
        if (type.equals("ByteArray")) {
            if (content instanceof byte[]) {
                return content;
            }
            if (content instanceof String) {
                return StandardConversions.hexToBytes(content.toString());
            }
            throw new EncodingException("Cannot read ByteArray!");
        }
        String strContent = content instanceof byte[] ? new String((byte[])content, StandardCharsets.UTF_8) : content.toString();
        switch (type) {
            case "java.lang.String": {
                return strContent;
            }
            case "java.lang.Boolean": {
                return Boolean.parseBoolean(strContent);
            }
            case "java.lang.Short": {
                return Short.parseShort(strContent);
            }
            case "java.lang.Byte": {
                return Byte.parseByte(strContent);
            }
            case "java.lang.Integer": {
                return Integer.parseInt(strContent);
            }
            case "java.lang.Long": {
                return Long.parseLong(strContent);
            }
            case "java.lang.Float": {
                return Float.valueOf(Float.parseFloat(strContent));
            }
            case "java.lang.Double": {
                return Double.parseDouble(strContent);
            }
        }
        return content;
    }

    public static byte[] convertCharset(Object content, Charset fromCharset, Charset toCharset) {
        if (content == null) {
            return null;
        }
        if (fromCharset == null || toCharset == null) {
            throw new NullPointerException("Charset cannot be null!");
        }
        byte[] bytes = content instanceof String ? content.toString().getBytes(fromCharset) : (content instanceof byte[] ? (byte[])content : content.toString().getBytes(fromCharset));
        if (fromCharset.equals(toCharset)) {
            return bytes;
        }
        CharBuffer inputContent = fromCharset.decode(ByteBuffer.wrap(bytes));
        ByteBuffer result = toCharset.encode(inputContent);
        return Arrays.copyOf(result.array(), result.limit());
    }

    public static byte[] decodeOctetStream(Object input, MediaType octetStream) {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof String) {
            String encoding = octetStream.getParameter("encoding").orElse("hex");
            String src = input.toString();
            return encoding.equals("hex") ? StandardConversions.hexToBytes(src) : Base64.getUrlDecoder().decode(src);
        }
        throw new EncodingException("Cannot decode binary content " + input.getClass());
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            r.append(HEX_DIGITS[b >> 4 & 0xF]);
            r.append(HEX_DIGITS[b & 0xF]);
        }
        return "0x" + r.toString();
    }

    private static int forDigit(char digit) {
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        if (digit == 'a') {
            return 10;
        }
        if (digit == 'b') {
            return 11;
        }
        if (digit == 'c') {
            return 12;
        }
        if (digit == 'd') {
            return 13;
        }
        if (digit == 'e') {
            return 14;
        }
        if (digit == 'f') {
            return 15;
        }
        throw new EncodingException("Invalid digit found in hex format!");
    }

    public static byte[] hexToBytes(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.isEmpty()) {
            return new byte[0];
        }
        if (!hex.startsWith("0x") || hex.length() % 2 != 0) {
            throw new EncodingException("Illegal hex literal!");
        }
        byte[] result = new byte[(hex.length() - 2) / 2];
        for (int i = 2; i < hex.length(); i += 2) {
            byte b;
            int msb = StandardConversions.forDigit(hex.charAt(i));
            int lsb = StandardConversions.forDigit(hex.charAt(i + 1));
            result[(i - 2) / 2] = b = (byte)(msb * 16 + lsb);
        }
        return result;
    }

    public static Object convertUrlEncodedToObject(Object content) {
        Object decoded = StandardConversions.urlDecode(content);
        return StandardConversions.convertTextToObject(decoded, MediaType.TEXT_PLAIN);
    }

    public static Object convertUrlEncodedToText(Object content, MediaType destinationType) {
        return StandardConversions.convertTextToText(StandardConversions.urlDecode(content), MediaType.TEXT_PLAIN, destinationType);
    }

    public static Object convertUrlEncodedToOctetStream(Object content) {
        return StandardConversions.convertTextToOctetStream(StandardConversions.urlDecode(content), MediaType.TEXT_PLAIN);
    }

    public static String urlEncode(Object content, MediaType mediaType) {
        if (content == null) {
            return null;
        }
        try {
            String asString = content instanceof byte[] ? new String((byte[])content, StandardCharsets.UTF_8) : content.toString();
            return URLEncoder.encode(asString, mediaType.getCharset().toString());
        }
        catch (UnsupportedEncodingException e) {
            throw Log.CONTAINER.errorEncoding(content, MediaType.APPLICATION_WWW_FORM_URLENCODED);
        }
    }

    public static Object urlDecode(Object content) {
        try {
            if (content == null) {
                return null;
            }
            if (content instanceof byte[]) {
                byte[] bytesSource = (byte[])content;
                return URLDecoder.decode(new String(bytesSource, StandardCharsets.UTF_8), StandardCharsets.UTF_8.toString());
            }
            return URLDecoder.decode(content.toString(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw Log.CONTAINER.cannotDecodeFormURLContent(content);
        }
    }

    public static Object convertOctetStreamToUrlEncoded(Object content, MediaType contentType) {
        byte[] decoded = StandardConversions.decodeOctetStream(content, contentType);
        return StandardConversions.urlEncode(decoded, MediaType.TEXT_PLAIN);
    }
}

