/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdaptiveBufferSizePredictor;
import org.infinispan.commons.marshall.BufferSizePredictor;

public final class MarshallableTypeHints {
    private static final Log log = LogFactory.getLog(MarshallableTypeHints.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentMap<Class<?>, MarshallingType> typeHints = new ConcurrentHashMap();

    public BufferSizePredictor getBufferSizePredictor(Class<?> type) {
        MarshallingType marshallingType = (MarshallingType)this.typeHints.get(type);
        if (marshallingType == null) {
            marshallingType = new MarshallingType(null, new AdaptiveBufferSizePredictor());
            MarshallingType prev = this.typeHints.putIfAbsent(type, marshallingType);
            if (prev != null) {
                marshallingType = prev;
            } else if (trace) {
                log.tracef("Cache a buffer size predictor for '%s' assuming its serializability is unknown", (Object)type.getName());
            }
        }
        return marshallingType.sizePredictor;
    }

    public BufferSizePredictor getBufferSizePredictor(Object obj) {
        return obj == null ? NullBufferSizePredictor.INSTANCE : this.getBufferSizePredictor(obj.getClass());
    }

    public boolean isKnownMarshallable(Class<?> type) {
        MarshallingType marshallingType = (MarshallingType)this.typeHints.get(type);
        return marshallingType != null && marshallingType.isMarshallable != null;
    }

    public boolean isMarshallable(Class<?> type) {
        MarshallingType marshallingType = (MarshallingType)this.typeHints.get(type);
        if (marshallingType != null) {
            Boolean marshallable = marshallingType.isMarshallable;
            return marshallable != null ? marshallable : false;
        }
        return false;
    }

    public void markMarshallable(Class<?> type, boolean isMarshallable) {
        MarshallingType marshallType = (MarshallingType)this.typeHints.get(type);
        if (this.marshallableUpdateRequired(isMarshallable, marshallType)) {
            boolean replaced = this.typeHints.replace(type, marshallType, new MarshallingType(isMarshallable, marshallType.sizePredictor));
            if (replaced && trace) {
                log.tracef("Replacing '%s' type to be marshallable=%b", (Object)type.getName(), (Object)isMarshallable);
            }
        } else if (marshallType == null) {
            if (trace) {
                log.tracef("Cache '%s' type to be marshallable=%b", (Object)type.getName(), (Object)isMarshallable);
            }
            this.typeHints.put(type, new MarshallingType(isMarshallable, new AdaptiveBufferSizePredictor()));
        }
    }

    public void clear() {
        this.typeHints.clear();
    }

    private boolean marshallableUpdateRequired(boolean isMarshallable, MarshallingType marshallType) {
        return marshallType != null && (marshallType.isMarshallable == null || marshallType.isMarshallable != isMarshallable);
    }

    static final class NullBufferSizePredictor
    implements BufferSizePredictor {
        static final BufferSizePredictor INSTANCE = new NullBufferSizePredictor();

        NullBufferSizePredictor() {
        }

        @Override
        public int nextSize(Object obj) {
            return 1;
        }

        @Override
        public void recordSize(int previousSize) {
        }
    }

    private static class MarshallingType {
        final Boolean isMarshallable;
        final BufferSizePredictor sizePredictor;

        private MarshallingType(Boolean marshallable, BufferSizePredictor sizePredictor) {
            this.isMarshallable = marshallable;
            this.sizePredictor = sizePredictor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MarshallingType that = (MarshallingType)o;
            if (this.isMarshallable != null ? !this.isMarshallable.equals(that.isMarshallable) : that.isMarshallable != null) {
                return false;
            }
            return !(this.sizePredictor != null ? !this.sizePredictor.equals(that.sizePredictor) : that.sizePredictor != null);
        }

        public int hashCode() {
            int result = this.isMarshallable != null ? this.isMarshallable.hashCode() : 0;
            result = 31 * result + (this.sizePredictor != null ? this.sizePredictor.hashCode() : 0);
            return result;
        }
    }
}

