/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.SecurityActions;

public class Features {
    private static final Log log = LogFactory.getLog(Features.class);
    public static final String FEATURE_PREFIX = "org.infinispan.feature.";
    static final String FEATURES_FILE = "META-INF/infinispan-features.properties";
    private final Properties features = new Properties();

    public Features(ClassLoader classLoader) {
        try {
            Collection<URL> featureFiles = FileLookupFactory.newInstance().lookupFileLocations(FEATURES_FILE, classLoader);
            for (URL url : featureFiles) {
                InputStream is = url.openStream();
                try {
                    this.features.load(is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if (log.isDebugEnabled()) {
                this.features.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> log.debugf("Feature %s=%s", key, value)));
            }
        }
        catch (IOException e) {
            log.debugf((Throwable)e, "Error while attempting to obtain `%s` resources from the classpath", (Object)FEATURES_FILE);
            throw new CacheConfigurationException(e);
        }
    }

    public Features() {
        this(Features.class.getClassLoader());
    }

    public boolean isAvailable(String featureName) {
        String name = FEATURE_PREFIX + featureName;
        String sysprop = SecurityActions.getProperty(name);
        if (sysprop != null) {
            return Boolean.parseBoolean(sysprop);
        }
        return Boolean.parseBoolean(this.features.getProperty(name, "true"));
    }
}

