/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AutoProtoSchemaBuilderAnnotationProcessor;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;

final class MarshallerSourceCodeGenerator
extends AbstractMarshallerCodeGenerator {
    private static final Log log = Log.LogFactory.getLog(MarshallerSourceCodeGenerator.class);
    private static final String DIGEST_ALG = "SHA-256";
    private final GeneratedFilesWriter generatedFilesWriter;
    private final Set<String> generatedClasses = new LinkedHashSet<String>();

    MarshallerSourceCodeGenerator(GeneratedFilesWriter generatedFilesWriter, XTypeFactory typeFactory, String protobufSchemaPackage) {
        super(typeFactory, protobufSchemaPackage);
        this.generatedFilesWriter = generatedFilesWriter;
    }

    @Override
    public void generateMarshaller(SerializationContext serCtx, ProtoTypeMetadata ptm) throws IOException {
        if (ptm instanceof ProtoMessageTypeMetadata) {
            this.generateMessageMarshaller((ProtoMessageTypeMetadata)ptm);
        } else if (ptm instanceof ProtoEnumTypeMetadata) {
            this.generateEnumMarshaller((ProtoEnumTypeMetadata)ptm);
        }
    }

    private String makeUniqueMarshallerClassName(ProtoTypeMetadata ptm) {
        String hash = MarshallerSourceCodeGenerator.hashStrings(ptm.getJavaClass().getName(), this.makeQualifiedTypeName(ptm.getFullName()));
        return ptm.getJavaClass().getSimpleName() + "$___Marshaller_" + hash;
    }

    private static String hashStrings(String ... strings) {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALG);
            for (int i = 0; i < strings.length; ++i) {
                if (i > 0) {
                    md.update((byte)0);
                }
                byte[] bytes = strings[i].getBytes(StandardCharsets.UTF_8);
                md.update(bytes);
            }
            byte[] digest = md.digest();
            return new BigInteger(1, digest).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute SHA-256 digest of strings", e);
        }
    }

    private void generateEnumMarshaller(ProtoEnumTypeMetadata petm) throws IOException {
        String fqn;
        String marshallerClassName = this.makeUniqueMarshallerClassName(petm);
        if (log.isTraceEnabled()) {
            log.tracef("Generating enum marshaller %s for %s", (Object)marshallerClassName, (Object)petm.getJavaClass().getName());
        }
        IndentWriter iw = new IndentWriter();
        if (petm.getJavaClass().getPackageName() != null) {
            fqn = petm.getJavaClass().getPackageName() + '.' + marshallerClassName;
            iw.append("package ").append(petm.getJavaClass().getPackageName()).append(";\n\n");
        } else {
            fqn = marshallerClassName;
        }
        iw.append("public final class ").append(marshallerClassName).append(" implements ").append(EnumMarshaller.class.getName()).append('<').append(petm.getJavaClassName()).append("> {\n\n");
        iw.inc();
        iw.append("@Override\npublic Class<").append(petm.getJavaClassName()).append("> getJavaClass() { return ").append(petm.getJavaClassName()).append(".class; }\n\n");
        iw.append("@Override\npublic String getTypeName() { return \"").append(this.makeQualifiedTypeName(petm.getFullName())).append("\"; }\n\n");
        String decodeSrc = this.generateEnumDecodeMethodBody(petm);
        String decodeSig = "public " + petm.getJavaClassName() + " decode(int $1)";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)decodeSig, (Object)decodeSrc);
        }
        iw.append("@Override\n").append(decodeSig).append(' ').append(decodeSrc).append('\n');
        String encodeSrc = this.generateEnumEncodeMethodBody(petm);
        String encodeSig = "public int encode(" + petm.getJavaClassName() + " $1) throws IllegalArgumentException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)encodeSig, (Object)encodeSrc);
        }
        iw.append("@Override\n").append(encodeSig).append(' ').append(encodeSrc);
        iw.dec();
        iw.append("}\n");
        this.emitSource(fqn, iw.toString(), petm);
    }

    private void generateMessageMarshaller(ProtoMessageTypeMetadata pmtm) throws IOException {
        String fqn;
        String marshallerClassName = this.makeUniqueMarshallerClassName(pmtm);
        if (log.isTraceEnabled()) {
            log.tracef("Generating message marshaller %s for %s", (Object)marshallerClassName, (Object)pmtm.getJavaClass().getName());
        }
        IndentWriter iw = new IndentWriter();
        if (pmtm.getJavaClass().getPackageName() != null) {
            fqn = pmtm.getJavaClass().getPackageName() + '.' + marshallerClassName;
            iw.append("package ").append(pmtm.getJavaClass().getPackageName()).append(";\n\n");
        } else {
            fqn = marshallerClassName;
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedAnnotation(iw, pmtm.getJavaClassName());
        iw.append("@SuppressWarnings(\"unchecked\")\n");
        iw.append("public final class ").append(marshallerClassName).append(" extends ").append(GeneratedMarshallerBase.class.getName()).append(" implements ").append(RawProtobufMarshaller.class.getName()).append('<').append(pmtm.getJavaClassName()).append('>').append(" {\n\n");
        iw.inc();
        this.addMarshallerDelegateFields(iw, pmtm);
        iw.append("@Override\npublic Class<").append(pmtm.getJavaClassName()).append("> getJavaClass() { return ").append(pmtm.getJavaClassName()).append(".class; }\n\n");
        iw.append("@Override\npublic String getTypeName() { return \"").append(this.makeQualifiedTypeName(pmtm.getFullName())).append("\"; }\n\n");
        String readFromSrc = this.generateReadFromMethodBody(pmtm);
        String readFromSig = "public " + pmtm.getJavaClassName() + " readFrom(" + ImmutableSerializationContext.class.getName() + " $1, " + RawProtoStreamReader.class.getName() + " $2) throws java.io.IOException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)readFromSig, (Object)readFromSrc);
        }
        iw.append("@Override\n").append(readFromSig).append(' ').append(readFromSrc).append('\n');
        String writeToSrc = this.generateWriteToMethodBody(pmtm);
        String writeToSig = "public void writeTo(" + ImmutableSerializationContext.class.getName() + " $1, " + RawProtoStreamWriter.class.getName() + " $2, " + pmtm.getJavaClassName() + " $3) throws java.io.IOException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)writeToSig, (Object)writeToSrc);
        }
        iw.append("@Override\n").append(writeToSig).append(' ').append(writeToSrc);
        iw.dec();
        iw.append("}\n");
        this.emitSource(fqn, iw.toString(), pmtm);
    }

    private void addMarshallerDelegateFields(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        HashSet<String> addedFields = new HashSet<String>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            switch (fieldMetadata.getProtobufType()) {
                case GROUP: 
                case MESSAGE: 
                case ENUM: {
                    String fieldName = this.makeMarshallerDelegateFieldName(fieldMetadata);
                    if (!addedFields.add(fieldName)) break;
                    Class marshallerDelegateClass = fieldMetadata.getJavaType().isEnum() ? EnumMarshallerDelegate.class : BaseMarshallerDelegate.class;
                    iw.append("private ").append(marshallerDelegateClass.getName()).append(' ').append(fieldName).append(";\n\n");
                }
            }
        }
    }

    private void emitSource(String fqn, String source, ProtoTypeMetadata ptm) throws IOException {
        this.generatedFilesWriter.addMarshallerSourceFile(fqn, source, ((HasModelElement)((Object)ptm.getJavaClass())).getElement());
        this.generatedClasses.add(fqn);
    }

    public Set<String> getGeneratedClasses() {
        return this.generatedClasses;
    }
}

