/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPrintStream
extends PrintStream {
    protected Logger logger;
    private StringBuilder buffer = new StringBuilder();
    protected boolean isError = false;

    public LoggingPrintStream(OutputStream outputStream, boolean isError) {
        super(outputStream);
        this.isError = isError;
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        try {
            this.logger = LoggerFactory.getLogger(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
    }

    protected void log(String s) {
        if (this.isError) {
            this.logger.error(s);
        } else {
            this.logger.info(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeString(String s) {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.buffer.append(s);
        }
    }

    private synchronized void newLine() {
        this.log(this.buffer.toString());
        this.buffer.delete(0, this.buffer.length());
    }

    @Override
    public void print(boolean b) {
        this.writeString(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.writeString(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.writeString(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.writeString(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.writeString(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.writeString(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.writeString(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        this.writeString(s == null ? "null" : s);
    }

    @Override
    public void print(Object obj) {
        this.writeString(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object x) {
        Logger logger2 = this.logger;
        synchronized (logger2) {
            this.print(x);
            this.newLine();
        }
    }

    public static void interceptSysOutSysErr() {
    }

    public static void resetInterceptSysOutSysErr() {
    }
}

