/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.kie.api.runtime.process.NodeInstance;

public class VariableUtil {
    public static String resolveVariable(String s, NodeInstance nodeInstance) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String variableValueString;
            Object variableValue;
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((org.jbpm.workflow.instance.NodeInstance)nodeInstance).resolveContextInstance("VariableScope", paramName);
            if (variableScopeInstance != null) {
                variableValue = variableScopeInstance.getVariable(paramName);
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
                continue;
            }
            try {
                variableValue = MVELSafeHelper.getEvaluator().eval(paramName, new NodeInstanceResolverFactory((org.jbpm.workflow.instance.NodeInstance)nodeInstance));
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
            }
            catch (Throwable throwable) {}
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }
}

