/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.PropertyDataFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertyDataFetcher
extends PropertyDataFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPropertyDataFetcher.class);

    public JsonPropertyDataFetcher(String propertyName) {
        super(propertyName);
    }

    @Override
    public Object get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source instanceof JsonNode) {
            JsonNode jsonObject = (JsonNode)source;
            String jsonPointer = this.getPropertyName();
            try {
                JsonNode value = jsonObject.findValue(jsonPointer);
                if (value == null) {
                    return null;
                }
                switch (value.getNodeType()) {
                    case OBJECT: 
                    case POJO: 
                    case ARRAY: {
                        return value;
                    }
                    case NUMBER: {
                        return value.numberValue();
                    }
                    case BOOLEAN: {
                        return value.asBoolean();
                    }
                    case STRING: {
                        return value.asText();
                    }
                }
                return null;
            }
            catch (Exception ex) {
                LOGGER.warn(ex.getMessage());
                return null;
            }
        }
        return super.get(environment);
    }
}

