/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.index.infinispan.protostream.ProtobufService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProtobufMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufMonitorService.class);
    private static final PathMatcher protoFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.proto");
    private static final String KOGITO_APPLICATION_PROTO = "kogito-application.proto";
    @Inject
    @ConfigProperty(name="kogito.protobuf.folder")
    Optional<String> protoFiles;
    @Inject
    @ConfigProperty(name="kogito.protobuf.watch", defaultValue="false")
    Boolean monitor;
    Consumer<Path> onFolderWatch;
    @Inject
    ProtobufService protobufService;
    ExecutorService executorService;

    public void onStart(@Observes StartupEvent ev) {
        if (this.protoFiles.isPresent()) {
            String folderPath = this.protoFiles.get();
            File protoFolder = new File(folderPath);
            if (!protoFolder.exists()) {
                throw new RuntimeException(String.format("Could not find proto files folder at: %s", folderPath));
            }
            this.registerFilesFromFolder(protoFolder.toPath());
            if (this.monitor.booleanValue()) {
                this.executorService = Executors.newSingleThreadExecutor();
                this.executorService.submit(new FolderWatcher(this.registerProtoFile(), protoFolder.toPath()));
            }
        }
    }

    private void registerFilesFromFolder(Path folderPath) {
        try (Stream<Path> stream = Files.find(folderPath, Integer.MAX_VALUE, (path, attrs) -> protoFileMatcher.matches((Path)path), new FileVisitOption[0]);){
            stream.filter(path -> !KOGITO_APPLICATION_PROTO.equals(path.getFileName().toFile().getName())).forEach(path -> this.registerProtoFile().accept((Path)path));
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Could not read content from proto file folder: %s", folderPath), ex);
        }
    }

    private Consumer<Path> registerProtoFile() {
        return path -> {
            try {
                LOGGER.info("Found proto file: {}", path);
                String content = new String(Files.readAllBytes(path));
                this.protobufService.registerProtoBufferType(content);
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("Could not read content from proto file folder", new Object[0]), ex);
            }
            catch (Exception e) {
                LOGGER.error("Failed to register proto file: {}", path, (Object)e);
                throw new RuntimeException(e);
            }
        };
    }

    void onStop(@Observes ShutdownEvent ev) {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private class FolderWatcher
    implements Runnable {
        private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
        private Consumer<Path> consumer;
        private Path folder;

        public FolderWatcher(Consumer<Path> consumer, Path folder) {
            this.consumer = consumer;
            this.folder = folder;
        }

        @Override
        public void run() {
            try (final WatchService ws = FileSystems.getDefault().newWatchService();){
                WatchKey key;
                this.keys.put(this.folder.register(ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE), this.folder);
                Files.walkFileTree(this.folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        FolderWatcher.this.keys.put(dir.register(ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE), dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (ProtobufMonitorService.this.onFolderWatch != null) {
                    ProtobufMonitorService.this.onFolderWatch.accept(this.folder);
                }
                while ((key = ws.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        LOGGER.debug("Event kind: {}. File affected: {}", (Object)event.kind(), event.context());
                        Path path = (Path)event.context();
                        Path proto = this.keys.get(key).resolve(path);
                        if (Files.isDirectory(proto, new LinkOption[0])) {
                            ProtobufMonitorService.this.registerFilesFromFolder(proto);
                            this.keys.put(proto.register(ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE), proto);
                            continue;
                        }
                        if (!protoFileMatcher.matches(path) || ProtobufMonitorService.KOGITO_APPLICATION_PROTO.equals(path.getFileName().toFile().getName())) continue;
                        this.consumer.accept(proto);
                    }
                    key.reset();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Exception in proto folder watcher for folder: {}, message: {}", this.folder, ex.getMessage(), ex);
            }
        }
    }
}

