/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Collections;
import org.jbpm.process.instance.LightProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntimeContext;
import org.jbpm.process.instance.LightProcessRuntimeServiceProvider;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.Model;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.impl.ConfiguredProcessServices;
import org.kie.kogito.process.impl.MapProcessInstances;
import org.kie.kogito.process.impl.Sig;

public abstract class AbstractProcess<T extends Model>
implements Process<T> {
    protected ProcessInstancesFactory processInstancesFactory;
    protected MutableProcessInstances<T> instances;
    protected final ProcessRuntimeServiceProvider services;
    protected CompletionEventListener completionEventListener = new CompletionEventListener();

    protected AbstractProcess() {
        this(new LightProcessRuntimeServiceProvider());
    }

    protected AbstractProcess(ProcessConfig config) {
        this(new ConfiguredProcessServices(config));
    }

    protected AbstractProcess(ProcessRuntimeServiceProvider services) {
        this.services = services;
        this.instances = new MapProcessInstances();
    }

    @Override
    public String id() {
        return this.legacyProcess().getId();
    }

    @Override
    public T createModel() {
        return null;
    }

    @Override
    public ProcessInstance<T> createInstance(Model m) {
        return this.createInstance(m);
    }

    @Override
    public ProcessInstances<T> instances() {
        return this.instances;
    }

    @Override
    public <S> void send(Signal<S> signal) {
        this.instances().values().forEach(pi -> pi.send(signal));
    }

    public Process<T> configure() {
        this.registerListeners();
        if (this.isProcessFactorySet()) {
            this.instances = this.processInstancesFactory.createProcessInstances(this);
        }
        return this;
    }

    protected void registerListeners() {
    }

    public abstract org.kie.api.definition.process.Process legacyProcess();

    protected ProcessRuntime createLegacyProcessRuntime() {
        return new LightProcessRuntime(new LightProcessRuntimeContext(Collections.singletonList(this.legacyProcess())), this.services);
    }

    protected boolean isProcessFactorySet() {
        return this.processInstancesFactory != null;
    }

    public void setProcessInstancesFactory(ProcessInstancesFactory processInstancesFactory) {
        this.processInstancesFactory = processInstancesFactory;
    }

    private class CompletionEventListener
    implements EventListener {
        private CompletionEventListener() {
        }

        @Override
        public void signalEvent(String type, Object event) {
            if (type.startsWith("processInstanceCompleted:")) {
                org.kie.api.runtime.process.ProcessInstance pi = (org.kie.api.runtime.process.ProcessInstance)event;
                if (!AbstractProcess.this.id().equals(pi.getProcessId()) && pi.getParentProcessInstanceId() != null) {
                    AbstractProcess.this.instances().findById(pi.getParentProcessInstanceId()).ifPresent(p -> p.send(Sig.of(type, event)));
                }
            }
        }

        @Override
        public String[] getEventTypes() {
            return new String[0];
        }
    }
}

