/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.provider.util;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.common.Assert;

public final class ProviderUtil {
    public static final Supplier<Provider[]> INSTALLED_PROVIDERS = Security::getProviders;

    public static Provider findProvider(Supplier<Provider[]> providerSupplier, String providerName, Class<?> serviceType, String algorithm) {
        Assert.checkNotNullParam("serviceType", serviceType);
        return ProviderUtil.findProvider(providerSupplier, providerName, serviceType.getSimpleName(), algorithm);
    }

    public static Provider findProvider(Supplier<Provider[]> providerSupplier, String providerName, String serviceType, String algorithm) {
        Provider.Service service = ProviderUtil.findProviderService(providerSupplier, providerName, serviceType, algorithm);
        return service == null ? null : service.getProvider();
    }

    public static Provider.Service findProviderService(Supplier<Provider[]> providerSupplier, String providerName, Class<?> serviceType, String algorithm) {
        Assert.checkNotNullParam("serviceType", serviceType);
        return ProviderUtil.findProviderService(providerSupplier, providerName, serviceType.getSimpleName(), algorithm);
    }

    public static Provider.Service findProviderService(Supplier<Provider[]> providerSupplier, String providerName, String serviceType, String algorithm) {
        Assert.checkNotNullParam("providerSupplier", providerSupplier);
        Assert.checkNotNullParam("serviceType", serviceType);
        Assert.checkNotNullParam("algorithm", algorithm);
        for (Provider provider : providerSupplier.get()) {
            Provider.Service providerService;
            if (providerName != null && !providerName.equals(provider.getName()) || (providerService = provider.getService(serviceType, algorithm)) == null) continue;
            return providerService;
        }
        return null;
    }

    public static Provider.Service findProviderService(Supplier<Provider[]> providerSupplier, Predicate<Provider.Service> matchPredicate) {
        Assert.checkNotNullParam("providerSupplier", providerSupplier);
        Assert.checkNotNullParam("matchPredicate", matchPredicate);
        for (Provider provider : providerSupplier.get()) {
            for (Provider.Service service : provider.getServices()) {
                if (!matchPredicate.test(service)) continue;
                return service;
            }
        }
        return null;
    }

    public static Supplier<Provider[]> aggregate(final Supplier<Provider[]> ... suppliers) {
        Assert.checkNotNullParam("suppliers", suppliers);
        return new Supplier<Provider[]>(){
            private volatile Provider[] result = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Provider[] get() {
                if (this.result != null) return (Provider[])this.result.clone();
                Supplier[] supplierArray = suppliers;
                synchronized (suppliers) {
                    if (this.result != null) return (Provider[])this.result.clone();
                    ArrayList<Provider[]> resolvedProviders = new ArrayList<Provider[]>(suppliers.length);
                    int count = 0;
                    for (Supplier current : suppliers) {
                        Provider[] resolved = (Provider[])current.get();
                        count += resolved.length;
                        resolvedProviders.add(resolved);
                    }
                    Provider[] tempResult = new Provider[count];
                    count = 0;
                    for (Provider[] p : resolvedProviders) {
                        System.arraycopy(p, 0, tempResult, (count += p.length) - p.length, p.length);
                    }
                    this.result = tempResult;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (Provider[])this.result.clone();
                }
            }
        };
    }
}

