/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.DataFetchingEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.model.ProcessInstance;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class GraphQLSchemaManagerTest {
    GraphQLSchemaManager schemaManager = new GraphQLSchemaManager();

    @Test
    public void testNullServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv(null, null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("travels", null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orders", null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orderItems", null))).isNull();
    }

    @Test
    public void testNullProcessIdServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("travels", "/travels"))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orders", "/orders"))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orderItems", "/orderItems"))).isNull();
    }

    @Test
    public void testUrlProcessIdServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("travels", "http://localhost:8080/travels"))).isEqualTo("http://localhost:8080");
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orders", "http://localhost:8080/orders"))).isEqualTo("http://localhost:8080");
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orderItems", "http://localhost:8080/orderItems"))).isEqualTo("http://localhost:8080");
    }

    private DataFetchingEnvironment getEnv(String processId, String endpoint) {
        DataFetchingEnvironment env = (DataFetchingEnvironment)Mockito.mock(DataFetchingEnvironment.class);
        Mockito.when((Object)env.getSource()).thenReturn((Object)this.getProcessInstance(processId, endpoint));
        return env;
    }

    private ProcessInstance getProcessInstance(String processId, String endpoint) {
        ProcessInstance pi = new ProcessInstance();
        pi.setProcessId(processId);
        pi.setEndpoint(endpoint);
        return pi;
    }
}

