/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.GraphQLUtils;
import org.kie.kogito.index.InfinispanServerTestResource;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.infinispan.protostream.ProtobufService;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@QuarkusTestResource(value=InfinispanServerTestResource.class)
public class IndexingServiceTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingServiceTest.class);
    @Inject
    ReactiveMessagingEventConsumer consumer;
    @Inject
    ProtobufService protobufService;

    @BeforeAll
    public static void setup() {
        RestAssured.config = RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(false));
    }

    private static String formatZonedDateTime(ZonedDateTime time) {
        return time.truncatedTo(ChronoUnit.MILLIS).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    @Test
    public void testAddBrokenProtoFile() {
        try {
            this.protobufService.registerProtoBufferType(this.getBrokenProtoBufferFile());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Failed to resolve type of field \"travels.traveller\". Type not found : stringa");
        }
    }

    @Test
    public void testAddProtoFileMissingModel() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutModel());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Missing marker for main message type in proto file, please add option kogito_model=\"messagename\"");
        }
    }

    @Test
    public void testAddProtoFileMissingId() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutId());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Missing marker for process id in proto file, please add option kogito_id=\"processid\"");
        }
    }

    @Test
    public void testAddProtoFileMissingModelType() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutModelType());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Could not find message with name: traveller in proto file, e, please review option kogito_model");
        }
    }

    @Test
    public void testAddProtoFileTwice() throws Exception {
        this.protobufService.registerProtoBufferType(this.getProtoBufferFileV1());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Game{ player, id, name, metadata { processInstances { id } } } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Game", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
        this.protobufService.registerProtoBufferType(this.getProtoBufferFileV2());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Game{ id, name, company, metadata { processInstances { id } } } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Game", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
    }

    @Test
    public void testDefaultGraphqlTypes() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{UserTaskInstances{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.UserTaskInstances", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Jobs{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Jobs", CoreMatchers.isA(Collection.class), new Object[0]);
    }

    @Test
    public void testAddProtoFile() throws Exception {
        String processId = "travels";
        String subProcessId = processId + "_sub";
        String processInstanceId = UUID.randomUUID().toString();
        String subProcessInstanceId = UUID.randomUUID().toString();
        String firstTaskId = UUID.randomUUID().toString();
        String secondTaskId = UUID.randomUUID().toString();
        String state = "InProgress";
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoProcessCloudEvent startEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.indexProcessCloudEvent(startEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndState(processInstanceId, ProcessInstanceState.ACTIVE), startEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByProcessInstanceId(processInstanceId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].__typename", CoreMatchers.is((Object)"Travels"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(startEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)startEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].end", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].endpoint", CoreMatchers.is((Object)startEvent.getSource().toString()), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0]);
        KogitoProcessCloudEvent subProcessStartEvent = TestUtils.getProcessCloudEvent(subProcessId, subProcessInstanceId, ProcessInstanceState.ACTIVE, processInstanceId, processId, processInstanceId);
        ((ProcessInstance)subProcessStartEvent.getData()).setVariables(JsonUtils.getObjectMapper().readTree("{ \"traveller\":{\"firstName\":\"Maciej\", \"email\":\"mail@mail.com\", \"nationality\":\"Polish\"} }"));
        subProcessStartEvent.setSource(URI.create("/" + subProcessId));
        this.indexProcessCloudEvent(subProcessStartEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndState(subProcessInstanceId, ProcessInstanceState.ACTIVE), subProcessStartEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndState(processInstanceId, ProcessInstanceState.ACTIVE), startEvent, subProcessInstanceId);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByProcessInstanceId(subProcessInstanceId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].__typename", CoreMatchers.is((Object)"Travels"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(subProcessStartEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)2), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)startEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].end", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].endpoint", CoreMatchers.is((Object)startEvent.getSource().toString()), new Object[0])).body("data.Travels[0].metadata.processInstances[1].id", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].processId", CoreMatchers.is((Object)subProcessId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].processName", CoreMatchers.is((Object)((ProcessInstance)subProcessStartEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[1].rootProcessId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].rootProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].parentProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)subProcessStartEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[1].end", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].traveller.email", CoreMatchers.is((Object)"mail@mail.com"), new Object[0])).body("data.Travels[0].traveller.nationality", CoreMatchers.is((Object)"Polish"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].flight.arrival", CoreMatchers.is((Object)"2019-08-20T22:12:57.340Z"), new Object[0])).body("data.Travels[0].flight.departure", CoreMatchers.is((Object)"2019-08-20T07:12:57.340Z"), new Object[0]);
        KogitoProcessCloudEvent endEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.COMPLETED, null, null, null);
        this.indexProcessCloudEvent(endEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndState(processInstanceId, ProcessInstanceState.COMPLETED), endEvent, subProcessInstanceId);
        KogitoUserTaskCloudEvent firstUserTaskEvent = TestUtils.getUserTaskCloudEvent(firstTaskId, subProcessId, subProcessInstanceId, processInstanceId, processId, state);
        this.indexUserTaskCloudEvent(firstUserTaskEvent);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceById(firstTaskId), firstUserTaskEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByUserTaskId(firstTaskId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].__typename", CoreMatchers.is((Object)"Travels"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(firstUserTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.userTasks[0].id", CoreMatchers.is((Object)firstTaskId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].processInstanceId", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].description", CoreMatchers.is((Object)"TaskDescription"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].name", CoreMatchers.is((Object)"TaskName"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)"High"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)"kogito"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(firstUserTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)2), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)endEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].end", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getEnd().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[1].id", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].processId", CoreMatchers.is((Object)subProcessId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].processName", CoreMatchers.is((Object)((ProcessInstance)subProcessStartEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[1].rootProcessId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].rootProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].parentProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)subProcessStartEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[1].end", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[1].endpoint", CoreMatchers.is((Object)subProcessStartEvent.getSource().toString()), new Object[0])).body("data.Travels[0].metadata.processInstances[1].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)subProcessStartEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].flight.arrival", CoreMatchers.is((Object)"2019-08-20T22:12:57.340Z"), new Object[0])).body("data.Travels[0].flight.departure", CoreMatchers.is((Object)"2019-08-20T07:12:57.340Z"), new Object[0]);
        KogitoUserTaskCloudEvent secondUserTaskEvent = TestUtils.getUserTaskCloudEvent(secondTaskId, processId, processInstanceId, null, null, state);
        this.indexUserTaskCloudEvent(secondUserTaskEvent);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceById(secondTaskId), secondUserTaskEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByUserTaskId(secondTaskId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].__typename", CoreMatchers.is((Object)"Travels"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(secondUserTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks.size()", CoreMatchers.is((Object)2), new Object[0])).body("data.Travels[0].metadata.userTasks[0].id", CoreMatchers.is((Object)firstTaskId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].processInstanceId", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].description", CoreMatchers.is((Object)"TaskDescription"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].name", CoreMatchers.is((Object)"TaskName"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)"High"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)"kogito"), new Object[0])).body("data.Travels[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)firstUserTaskEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks[1].id", CoreMatchers.is((Object)secondTaskId), new Object[0])).body("data.Travels[0].metadata.userTasks[1].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.userTasks[1].description", CoreMatchers.is((Object)"TaskDescription"), new Object[0])).body("data.Travels[0].metadata.userTasks[1].name", CoreMatchers.is((Object)"TaskName"), new Object[0])).body("data.Travels[0].metadata.userTasks[1].priority", CoreMatchers.is((Object)"High"), new Object[0])).body("data.Travels[0].metadata.userTasks[1].actualOwner", CoreMatchers.is((Object)"kogito"), new Object[0])).body("data.Travels[0].metadata.userTasks[1].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)secondUserTaskEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)2), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)endEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].end", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getEnd().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[1].id", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].processId", CoreMatchers.is((Object)subProcessId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].processName", CoreMatchers.is((Object)((ProcessInstance)subProcessStartEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[1].rootProcessId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].rootProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].parentProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[1].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)subProcessStartEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[1].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)subProcessStartEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[1].end", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].flight.arrival", CoreMatchers.is((Object)"2019-08-20T22:12:57.340Z"), new Object[0])).body("data.Travels[0].flight.departure", CoreMatchers.is((Object)"2019-08-20T07:12:57.340Z"), new Object[0]);
    }

    private void validateProcessInstance(String query, KogitoProcessCloudEvent event, String childProcessInstanceId) {
        LOGGER.debug("GraphQL query: {}", (Object)query);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(query).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances[0].id", CoreMatchers.is((Object)event.getProcessInstanceId()), new Object[0])).body("data.ProcessInstances[0].processId", CoreMatchers.is((Object)event.getProcessId()), new Object[0])).body("data.ProcessInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)event.getData()).getProcessName()), new Object[0])).body("data.ProcessInstances[0].rootProcessId", CoreMatchers.is((Object)event.getRootProcessId()), new Object[0])).body("data.ProcessInstances[0].rootProcessInstanceId", CoreMatchers.is((Object)event.getRootProcessInstanceId()), new Object[0])).body("data.ProcessInstances[0].parentProcessInstanceId", CoreMatchers.is((Object)event.getParentProcessInstanceId()), new Object[0])).body("data.ProcessInstances[0].parentProcessInstance.id", event.getParentProcessInstanceId() == null ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Object)event.getParentProcessInstanceId()), new Object[0])).body("data.ProcessInstances[0].parentProcessInstance.processName", event.getParentProcessInstanceId() == null ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.emptyOrNullString())), new Object[0])).body("data.ProcessInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)event.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.ProcessInstances[0].end", ((ProcessInstance)event.getData()).getEnd() == null ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)event.getData()).getEnd().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.ProcessInstances[0].childProcessInstances[0].id", childProcessInstanceId == null ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Object)childProcessInstanceId), new Object[0])).body("data.ProcessInstances[0].childProcessInstances[0].processName", childProcessInstanceId == null ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.emptyOrNullString())), new Object[0])).body("data.ProcessInstances[0].endpoint", CoreMatchers.is((Object)event.getSource().toString()), new Object[0])).body("data.ProcessInstances[0].serviceUrl", event.getSource().toString().equals("/" + event.getProcessId()) ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Object)"http://localhost:8080"), new Object[0])).body("data.ProcessInstances[0].addons", Matchers.hasItems((Object[])((ProcessInstance)event.getData()).getAddons().toArray()), new Object[0])).body("data.ProcessInstances[0].error.message", ((ProcessInstance)event.getData()).getError() == null ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Object)((ProcessInstance)event.getData()).getError().getMessage()), new Object[0])).body("data.ProcessInstances[0].error.nodeDefinitionId", ((ProcessInstance)event.getData()).getError() == null ? CoreMatchers.is((Matcher)CoreMatchers.nullValue()) : CoreMatchers.is((Object)((ProcessInstance)event.getData()).getError().getNodeDefinitionId()), new Object[0])).body("data.ProcessInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)event.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    private void validateProcessInstance(String query, KogitoProcessCloudEvent event) {
        this.validateProcessInstance(query, event, null);
    }

    private void indexProcessCloudEvent(KogitoProcessCloudEvent event) throws Exception {
        CompletableFuture.allOf(this.consumer.onProcessInstanceEvent(() -> event).toCompletableFuture(), this.consumer.onProcessInstanceDomainEvent(() -> event).toCompletableFuture()).get();
    }

    private void indexUserTaskCloudEvent(KogitoUserTaskCloudEvent event) throws Exception {
        CompletableFuture.allOf(this.consumer.onUserTaskInstanceEvent(() -> event).toCompletableFuture(), this.consumer.onUserTaskInstanceDomainEvent(() -> event).toCompletableFuture()).get();
    }

    @Test
    public void testIndexingDomainUsingUserTaskEventFirst() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String state = "InProgress";
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoUserTaskCloudEvent userTaskEvent = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, state);
        this.consumer.onUserTaskInstanceDomainEvent(() -> userTaskEvent).toCompletableFuture().get();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByUserTaskId(taskId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].__typename", CoreMatchers.is((Object)"Travels"), new Object[0])).body("data.Travels[0].flight", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].hotel", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].traveller", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(userTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(userTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0]);
        KogitoProcessCloudEvent processEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.consumer.onProcessInstanceDomainEvent(() -> processEvent).toCompletableFuture().get();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByProcessInstanceId(processInstanceId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].__typename", CoreMatchers.is((Object)"Travels"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(processEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(userTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)processEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(processEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    @Test
    public void testIndexingDomainUsingProcessEventFirst() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String state = "InProgress";
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoProcessCloudEvent processEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.consumer.onProcessInstanceDomainEvent(() -> processEvent).toCompletableFuture().get();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByProcessInstanceId(processInstanceId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(processEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)processEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(processEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
        KogitoUserTaskCloudEvent userTaskEvent = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, state);
        this.consumer.onUserTaskInstanceDomainEvent(() -> userTaskEvent).toCompletableFuture().get();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByUserTaskId(taskId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(userTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(userTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)processEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(processEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    @Test
    public void testIndexingDomainParallelEvents() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String state = "InProgress";
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoProcessCloudEvent processEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        KogitoUserTaskCloudEvent userTaskEvent = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, state);
        CompletableFuture.allOf(this.consumer.onProcessInstanceDomainEvent(() -> processEvent).toCompletableFuture(), this.consumer.onUserTaskInstanceDomainEvent(() -> userTaskEvent).toCompletableFuture()).get();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByProcessInstanceId(processInstanceId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(userTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(userTaskEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)processEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(processEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    @Test
    public void testProcessInstanceIndex() throws Exception {
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        String subProcessId = processId + "_sub";
        String subProcessInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoProcessCloudEvent startEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.indexProcessCloudEvent(startEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceById(processInstanceId), startEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndState(processInstanceId, ProcessInstanceState.ACTIVE), startEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndProcessId(processInstanceId, processId), startEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndStart(processInstanceId, IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getStart())), startEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndAddon(processInstanceId, "process-management"), startEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByProcessInstanceId(processInstanceId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(startEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)startEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].state", CoreMatchers.is((Object)ProcessInstanceState.ACTIVE.name()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].end", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0]);
        KogitoProcessCloudEvent endEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.COMPLETED, null, null, null);
        ((ProcessInstance)endEvent.getData()).setEnd(ZonedDateTime.now());
        ((ProcessInstance)endEvent.getData()).setVariables(JsonUtils.getObjectMapper().readTree("{ \"traveller\":{\"firstName\":\"Maciej\"},\"hotel\":{\"name\":\"Ibis\"},\"flight\":{\"arrival\":\"2019-08-20T22:12:57.340Z\",\"departure\":\"2019-08-20T07:12:57.340Z\",\"flightNumber\":\"QF444\"} }"));
        this.indexProcessCloudEvent(endEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndState(processInstanceId, ProcessInstanceState.COMPLETED), endEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getTravelsByProcessInstanceId(processInstanceId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(endEvent.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].metadata.processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].metadata.processInstances[0].processName", CoreMatchers.is((Object)((ProcessInstance)endEvent.getData()).getProcessName()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].rootProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].parentProcessInstanceId", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].state", CoreMatchers.is((Object)ProcessInstanceState.COMPLETED.name()), new Object[0])).body("data.Travels[0].metadata.processInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].metadata.processInstances[0].end", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)endEvent.getData()).getEnd().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"QF444"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Ibis"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0]);
        KogitoProcessCloudEvent event = TestUtils.getProcessCloudEvent(subProcessId, subProcessInstanceId, ProcessInstanceState.ACTIVE, processInstanceId, processId, processInstanceId);
        this.indexProcessCloudEvent(event);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByParentProcessInstanceId(processInstanceId), event);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndNullParentProcessInstanceId(processInstanceId, true), endEvent, subProcessInstanceId);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByRootProcessInstanceId(processInstanceId), event);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndNullRootProcessInstanceId(processInstanceId, true), endEvent, subProcessInstanceId);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceById(processInstanceId), endEvent, subProcessInstanceId);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndParentProcessInstanceId(subProcessInstanceId, processInstanceId), event);
        KogitoProcessCloudEvent errorEvent = TestUtils.getProcessCloudEvent(subProcessId, subProcessInstanceId, ProcessInstanceState.ERROR, processInstanceId, processId, processInstanceId);
        this.indexProcessCloudEvent(errorEvent);
        this.validateProcessInstance(GraphQLUtils.getProcessInstanceByIdAndErrorNode(subProcessInstanceId, ((ProcessInstance)errorEvent.getData()).getError().getNodeDefinitionId()), errorEvent);
    }

    @Test
    public void testUserTaskInstanceIndex() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String state = "InProgress";
        String processId = "deals";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getDealsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Deals{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Deals", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoUserTaskCloudEvent event = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, state);
        this.indexUserTaskCloudEvent(event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceById(taskId), event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceByIdAndActualOwner(taskId, "kogito"), event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceByIdAndPotentialGroups(taskId, new ArrayList<String>(((UserTaskInstance)event.getData()).getPotentialGroups())), event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceByIdAndPotentialUsers(taskId, new ArrayList<String>(((UserTaskInstance)event.getData()).getPotentialUsers())), event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceByIdAndState(taskId, ((UserTaskInstance)event.getData()).getState()), event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceByIdAndStarted(taskId, IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getStarted())), event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceByIdAndCompleted(taskId, IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getCompleted())), event);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getDealsByTaskId(taskId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Deals[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Deals[0].__typename", CoreMatchers.is((Object)"Deals"), new Object[0])).body("data.Deals[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(event.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Deals[0].metadata.userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Deals[0].metadata.userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Deals[0].metadata.userTasks[0].description", CoreMatchers.is((Object)"TaskDescription"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].state", CoreMatchers.is((Object)"InProgress"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].name", CoreMatchers.is((Object)"TaskName"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)"High"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)"kogito"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].started", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getStarted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Deals[0].metadata.userTasks[0].completed", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getCompleted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Deals[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(event.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
        event = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, state);
        ((UserTaskInstance)event.getData()).setCompleted(ZonedDateTime.now());
        ((UserTaskInstance)event.getData()).setPriority("Low");
        ((UserTaskInstance)event.getData()).setActualOwner("admin");
        ((UserTaskInstance)event.getData()).setState("Completed");
        this.indexUserTaskCloudEvent(event);
        this.validateUserTaskInstance(GraphQLUtils.getUserTaskInstanceByIdAndActualOwner(taskId, "admin"), event);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(GraphQLUtils.getDealsByTaskId(taskId)).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Deals[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Deals[0].__typename", CoreMatchers.is((Object)"Deals"), new Object[0])).body("data.Deals[0].metadata.lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(event.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Deals[0].metadata.userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Deals[0].metadata.userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Deals[0].metadata.userTasks[0].description", CoreMatchers.is((Object)"TaskDescription"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].state", CoreMatchers.is((Object)"Completed"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].name", CoreMatchers.is((Object)"TaskName"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].priority", CoreMatchers.is((Object)"Low"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].actualOwner", CoreMatchers.is((Object)"admin"), new Object[0])).body("data.Deals[0].metadata.userTasks[0].started", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getStarted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Deals[0].metadata.userTasks[0].completed", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getCompleted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Deals[0].metadata.userTasks[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(event.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    @Test
    public void testJobIndex() throws Exception {
        String jobId = UUID.randomUUID().toString();
        String processId = "deals";
        String processInstanceId = UUID.randomUUID().toString();
        KogitoJobCloudEvent event = TestUtils.getJobCloudEvent(jobId, processId, processInstanceId, null, null, "EXECUTED");
        this.consumer.onJobEvent(() -> event).toCompletableFuture().get();
        this.validateJob(GraphQLUtils.getJobById(jobId), event);
    }

    private void validateJob(String query, KogitoJobCloudEvent event) {
        LOGGER.debug("GraphQL query: {}", (Object)query);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(query).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Jobs[0].id", CoreMatchers.is((Object)((Job)event.getData()).getId()), new Object[0])).body("data.Jobs[0].processId", CoreMatchers.is((Object)((Job)event.getData()).getProcessId()), new Object[0])).body("data.Jobs[0].processInstanceId", CoreMatchers.is((Object)((Job)event.getData()).getProcessInstanceId()), new Object[0])).body("data.Jobs[0].rootProcessId", CoreMatchers.is((Object)((Job)event.getData()).getRootProcessId()), new Object[0])).body("data.Jobs[0].rootProcessInstanceId", CoreMatchers.is((Object)((Job)event.getData()).getRootProcessInstanceId()), new Object[0])).body("data.Jobs[0].status", CoreMatchers.is((Object)((Job)event.getData()).getStatus()), new Object[0])).body("data.Jobs[0].expirationTime", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((Job)event.getData()).getExpirationTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Jobs[0].priority", CoreMatchers.is((Object)((Job)event.getData()).getPriority()), new Object[0])).body("data.Jobs[0].callbackEndpoint", CoreMatchers.is((Object)((Job)event.getData()).getCallbackEndpoint()), new Object[0])).body("data.Jobs[0].repeatInterval", CoreMatchers.is((Object)((Job)event.getData()).getRepeatInterval().intValue()), new Object[0])).body("data.Jobs[0].repeatLimit", CoreMatchers.is((Object)((Job)event.getData()).getRepeatLimit()), new Object[0])).body("data.Jobs[0].scheduledId", CoreMatchers.is((Object)((Job)event.getData()).getScheduledId()), new Object[0])).body("data.Jobs[0].retries", CoreMatchers.is((Object)((Job)event.getData()).getRetries()), new Object[0])).body("data.Jobs[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((Job)event.getData()).getLastUpdate().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Jobs[0].executionCounter", CoreMatchers.is((Object)((Job)event.getData()).getExecutionCounter()), new Object[0]);
    }

    private void validateUserTaskInstance(String query, KogitoUserTaskCloudEvent event) {
        LOGGER.debug("GraphQL query: {}", (Object)query);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(query).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.UserTaskInstances[0].id", CoreMatchers.is((Object)event.getUserTaskInstanceId()), new Object[0])).body("data.UserTaskInstances[0].processId", CoreMatchers.is((Object)event.getProcessId()), new Object[0])).body("data.UserTaskInstances[0].rootProcessId", CoreMatchers.is((Object)event.getRootProcessId()), new Object[0])).body("data.UserTaskInstances[0].rootProcessInstanceId", CoreMatchers.is((Object)event.getRootProcessInstanceId()), new Object[0])).body("data.UserTaskInstances[0].description", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getDescription()), new Object[0])).body("data.UserTaskInstances[0].name", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getName()), new Object[0])).body("data.UserTaskInstances[0].priority", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getPriority()), new Object[0])).body("data.UserTaskInstances[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getActualOwner()), new Object[0])).body("data.UserTaskInstances[0].excludedUsers", Matchers.hasItems((Object[])((UserTaskInstance)event.getData()).getExcludedUsers().toArray()), new Object[0])).body("data.UserTaskInstances[0].potentialUsers", Matchers.hasItems((Object[])((UserTaskInstance)event.getData()).getPotentialUsers().toArray()), new Object[0])).body("data.UserTaskInstances[0].potentialGroups", Matchers.hasItems((Object[])((UserTaskInstance)event.getData()).getPotentialGroups().toArray()), new Object[0])).body("data.UserTaskInstances[0].started", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getStarted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.UserTaskInstances[0].completed", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getCompleted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.UserTaskInstances[0].lastUpdate", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(event.getTime().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    private String getProtoBufferFileWithoutModelType() {
        return "   option kogito_id=\"travels\";\n   option kogito_model=\"traveller\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileWithoutId() {
        return "   option kogito_model=\"travels\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileWithoutModel() {
        return "   option kogito_id=\"travels\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getBrokenProtoBufferFile() {
        return "message travels {\n   optional stringa traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileV1() {
        return "import \"kogito-index.proto\";\noption kogito_model=\"Game\";\noption kogito_id=\"game\";\nmessage Game {\n   optional string player = 1;\n   optional string id = 2;\n   optional string name = 3;\n   optional org.kie.kogito.index.model.KogitoMetadata metadata = 4;\n}\n\n";
    }

    private String getProtoBufferFileV2() {
        return "import \"kogito-index.proto\";\noption kogito_model=\"Game\";\noption kogito_id=\"game\";\nmessage Game {\n   optional string id = 1;\n   optional string name = 2;\n   optional string company = 3;\n   optional org.kie.kogito.index.model.KogitoMetadata metadata = 4;\n}\n\n";
    }
}

