/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.index.infinispan.query.InfinispanQuery;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.query.AttributeFilter;
import org.kie.kogito.index.query.QueryFilterFactory;
import org.kie.kogito.index.query.SortDirection;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class InfinispanQueryTest {
    @Mock
    QueryFactory factory;
    @Mock
    Query mockQuery;

    private static Stream<Arguments> provideFilters() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.like((String)"name", (String)"test%")), "from org.kie.kogito.index.model.ProcessInstance o where o.name like 'test%'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.in((String)"id", Arrays.asList("8035b580-6ae4-4aa8-9ec0-e18e19809e0b", "a1e139d5-4e77-48c9-84ae-34578e904e5a"))), "from org.kie.kogito.index.model.ProcessInstance o where o.id in ('8035b580-6ae4-4aa8-9ec0-e18e19809e0b', 'a1e139d5-4e77-48c9-84ae-34578e904e5a')"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.equalTo((String)"id", (Object)"8035b580-6ae4-4aa8-9ec0-e18e19809e0b")), "from org.kie.kogito.index.model.ProcessInstance o where o.id = '8035b580-6ae4-4aa8-9ec0-e18e19809e0b'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.contains((String)"name", (String)"test")), "from org.kie.kogito.index.model.ProcessInstance o where o.name = 'test'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.containsAll((String)"name", Arrays.asList("name1", "name2"))), "from org.kie.kogito.index.model.ProcessInstance o where o.name = 'name1' and o.name = 'name2'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.containsAny((String)"name", Arrays.asList("name1", "name2"))), "from org.kie.kogito.index.model.ProcessInstance o where o.name = 'name1' or o.name = 'name2'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.isNull((String)"name")), "from org.kie.kogito.index.model.ProcessInstance o where o.name is null"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.notNull((String)"name")), "from org.kie.kogito.index.model.ProcessInstance o where o.name is not null"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.between((String)"start", (Object)"2019-01-01", (Object)"2020-01-01")), "from org.kie.kogito.index.model.ProcessInstance o where o.start between '2019-01-01' and '2020-01-01'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.greaterThan((String)"priority", (Object)1)), "from org.kie.kogito.index.model.ProcessInstance o where o.priority > 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.greaterThanEqual((String)"priority", (Object)1)), "from org.kie.kogito.index.model.ProcessInstance o where o.priority >= 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.lessThan((String)"priority", (Object)1)), "from org.kie.kogito.index.model.ProcessInstance o where o.priority < 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1)), "from org.kie.kogito.index.model.ProcessInstance o where o.priority <= 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1), QueryFilterFactory.greaterThan((String)"priority", (Object)1)))), "from org.kie.kogito.index.model.ProcessInstance o where o.priority <= 1 and o.priority > 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1), QueryFilterFactory.greaterThan((String)"priority", (Object)1)))), "from org.kie.kogito.index.model.ProcessInstance o where o.priority <= 1 or o.priority > 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.notNull((String)"name"), QueryFilterFactory.contains((String)"name", (String)"test"))), QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1), QueryFilterFactory.greaterThan((String)"priority", (Object)1)))), "from org.kie.kogito.index.model.ProcessInstance o where o.name is not null and o.name = 'test' and o.priority <= 1 or o.priority > 1"}));
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.factory.create((String)ArgumentMatchers.any())).thenReturn((Object)this.mockQuery);
    }

    @Test
    public void testNoParameters() {
        InfinispanQuery query = new InfinispanQuery(this.factory, ProcessInstance.class.getName());
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("from org.kie.kogito.index.model.ProcessInstance o");
        ((Query)Mockito.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void testEmptyParameters() {
        InfinispanQuery query = new InfinispanQuery(this.factory, ProcessInstance.class.getName());
        query.filter(Collections.emptyList());
        query.sort(Collections.emptyList());
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("from org.kie.kogito.index.model.ProcessInstance o");
        ((Query)Mockito.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void testPagination() {
        InfinispanQuery query = new InfinispanQuery(this.factory, ProcessInstance.class.getName());
        query.limit(Integer.valueOf(10));
        query.offset(Integer.valueOf(0));
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("from org.kie.kogito.index.model.ProcessInstance o");
        ((Query)Mockito.verify((Object)this.mockQuery)).startOffset(0L);
        ((Query)Mockito.verify((Object)this.mockQuery)).maxResults(10);
        ((Query)Mockito.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void testOrderBy() {
        InfinispanQuery query = new InfinispanQuery(this.factory, ProcessInstance.class.getName());
        query.sort(Arrays.asList(QueryFilterFactory.orderBy((String)"name", (SortDirection)SortDirection.DESC), QueryFilterFactory.orderBy((String)"date", (SortDirection)SortDirection.ASC)));
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("from org.kie.kogito.index.model.ProcessInstance o order by o.name DESC, o.date ASC");
        ((Query)Mockito.verify((Object)this.mockQuery)).list();
    }

    @ParameterizedTest
    @MethodSource(value={"provideFilters"})
    public void assertQueryFilters(List<AttributeFilter> filters, String queryString) {
        InfinispanQuery query = new InfinispanQuery(this.factory, ProcessInstance.class.getName());
        query.filter(filters);
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create(queryString);
        ((Query)Mockito.verify((Object)this.mockQuery)).list();
    }
}

