/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.cache.Cache;
import org.kie.kogito.index.event.SchemaRegisteredEvent;
import org.kie.kogito.index.infinispan.cache.InfinispanCacheManager;
import org.kie.kogito.index.infinispan.protostream.ProtoSchemaAcceptor;
import org.kie.kogito.index.infinispan.protostream.ProtoSchemaManager;
import org.kie.kogito.index.schema.ProcessDescriptor;
import org.kie.kogito.index.schema.SchemaDescriptor;
import org.kie.kogito.index.schema.SchemaRegistrationException;
import org.kie.kogito.index.schema.SchemaType;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ProtoSchemaManagerTest {
    @Mock
    ProtoSchemaAcceptor protoSchemaAcceptor;
    @Mock
    InfinispanCacheManager infinispanCacheManager;
    @InjectMocks
    ProtoSchemaManager protoSchemaManager;
    @Mock
    Map<String, String> protobufCache;
    @Mock
    Cache<String, String> processIdModelCache;

    ProtoSchemaManagerTest() {
    }

    @BeforeEach
    void prepare() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.protoSchemaAcceptor.accept((SchemaType)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.infinispanCacheManager.getProtobufCache()).thenReturn(this.protobufCache);
        Mockito.when((Object)this.infinispanCacheManager.getProcessIdModelCache()).thenReturn(this.processIdModelCache);
    }

    @Test
    void onSchemaRegisteredEvent() {
        String processId = "testProcessId";
        String processType = "testProcessType";
        ProcessDescriptor processDescriptor = new ProcessDescriptor(processId, processType);
        String name = "testName";
        String content = "testContent";
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(name, content, processDescriptor);
        SchemaType schemaType = new SchemaType("proto");
        SchemaRegisteredEvent event = new SchemaRegisteredEvent(schemaDescriptor, schemaType);
        this.protoSchemaManager.onSchemaRegisteredEvent(event);
        ((ProtoSchemaAcceptor)Mockito.verify((Object)this.protoSchemaAcceptor)).accept((SchemaType)ArgumentMatchers.eq((Object)schemaType));
        ((Map)Mockito.verify(this.protobufCache)).put((String)ArgumentMatchers.eq((Object)name), (String)ArgumentMatchers.eq((Object)content));
        ((Cache)Mockito.verify(this.processIdModelCache)).put((Object)((String)ArgumentMatchers.eq((Object)processId)), (Object)((String)ArgumentMatchers.eq((Object)processType)));
    }

    @Test
    void onSchemaRegisteredEventWithError() {
        String processId = "testProcessId";
        String processType = "testProcessType";
        ProcessDescriptor processDescriptor = new ProcessDescriptor(processId, processType);
        String name = "testName";
        String content = "testContent";
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(name, content, processDescriptor);
        SchemaType schemaType = new SchemaType("proto");
        SchemaRegisteredEvent event = new SchemaRegisteredEvent(schemaDescriptor, schemaType);
        Mockito.when((Object)this.protobufCache.containsKey(ArgumentMatchers.eq((Object)".errors"))).thenReturn((Object)true);
        Mockito.when((Object)this.protobufCache.get(ArgumentMatchers.eq((Object)".errors"))).thenReturn((Object)"testError");
        Assertions.assertThrows(SchemaRegistrationException.class, () -> this.protoSchemaManager.onSchemaRegisteredEvent(event));
        ((ProtoSchemaAcceptor)Mockito.verify((Object)this.protoSchemaAcceptor)).accept((SchemaType)ArgumentMatchers.eq((Object)schemaType));
        ((Map)Mockito.verify(this.protobufCache)).put((String)ArgumentMatchers.eq((Object)name), (String)ArgumentMatchers.eq((Object)content));
        ((Cache)Mockito.verify(this.processIdModelCache)).put((Object)((String)ArgumentMatchers.eq((Object)processId)), (Object)((String)ArgumentMatchers.eq((Object)processType)));
    }
}

