/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.kie.kogito.index.event.SchemaRegisteredEvent;
import org.kie.kogito.index.infinispan.cache.InfinispanCacheManager;
import org.kie.kogito.index.infinispan.protostream.ProtoSchemaAcceptor;
import org.kie.kogito.index.schema.SchemaDescriptor;
import org.kie.kogito.index.schema.SchemaRegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProtoSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoSchemaManager.class);
    @Inject
    ProtoSchemaAcceptor schemaAcceptor;
    @Inject
    @Any
    InfinispanCacheManager cacheManager;

    public void onSchemaRegisteredEvent(@Observes SchemaRegisteredEvent event) {
        if (this.schemaAcceptor.accept(event.getSchemaType())) {
            SchemaDescriptor schemaDescriptor = event.getSchemaDescriptor();
            this.cacheManager.getProtobufCache().put(schemaDescriptor.getName(), schemaDescriptor.getSchemaContent());
            schemaDescriptor.getProcessDescriptor().ifPresent(processDescriptor -> {
                Map<String, String> cache = this.cacheManager.getProtobufCache();
                this.cacheManager.getProcessIdModelCache().put((Object)processDescriptor.getProcessId(), (Object)processDescriptor.getProcessType());
                List<String> errors = this.checkSchemaErrors(cache);
                if (!errors.isEmpty()) {
                    String message = "Proto Schema contain errors:\n" + String.join((CharSequence)"\n", errors);
                    throw new SchemaRegistrationException(message);
                }
                if (LOGGER.isDebugEnabled()) {
                    this.logProtoCacheKeys();
                }
            });
        }
    }

    private List<String> checkSchemaErrors(Map<String, String> metadataCache) {
        if (metadataCache.containsKey(".errors")) {
            ArrayList<String> errors = new ArrayList<String>();
            String files = metadataCache.get(".errors");
            for (String fname : files.split("\n")) {
                String errorKey = fname + ".errors";
                String error = metadataCache.get(errorKey);
                LOGGER.warn("Found errors in Protobuf schema file: {}\n{}\n", (Object)fname, (Object)error);
                errors.add(String.format("Protobuf schema file: %s\n%s\n", fname, error));
            }
            return errors;
        }
        return Collections.emptyList();
    }

    private void logProtoCacheKeys() {
        LOGGER.debug(">>>>>>list cache keys start");
        this.cacheManager.getProtobufCache().entrySet().forEach(e -> LOGGER.debug(e.toString()));
        LOGGER.debug(">>>>>>list cache keys end");
    }
}

