/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.DataIndexStorageService;
import org.kie.kogito.index.infinispan.schema.ProtoSchemaAcceptor;
import org.kie.kogito.index.infinispan.schema.ProtoSchemaManager;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.api.schema.SchemaRegistrationException;
import org.kie.kogito.persistence.api.schema.SchemaType;
import org.kie.kogito.persistence.infinispan.cache.ProtobufCacheService;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ProtoSchemaManagerTest {
    @Mock
    ProtoSchemaAcceptor protoSchemaAcceptor;
    @Mock
    DataIndexStorageService cacheManager;
    @Mock
    ProtobufCacheService protobufCacheService;
    @InjectMocks
    ProtoSchemaManager protoSchemaManager;
    @Mock
    Storage<String, String> protobufCache;
    @Mock
    Storage<String, String> processIdModelCache;

    ProtoSchemaManagerTest() {
    }

    @BeforeEach
    void prepare() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.protoSchemaAcceptor.accept((SchemaType)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.protobufCacheService.getProtobufCache()).thenReturn(this.protobufCache);
        Mockito.when((Object)this.cacheManager.getProcessIdModelCache()).thenReturn(this.processIdModelCache);
    }

    @Test
    void onSchemaRegisteredEvent() {
        String processId = "testProcessId";
        String processType = "testProcessType";
        ProcessDescriptor processDescriptor = new ProcessDescriptor(processId, processType);
        String name = "testName";
        String content = "testContent";
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(name, content, null, processDescriptor);
        SchemaType schemaType = new SchemaType("proto");
        SchemaRegisteredEvent event = new SchemaRegisteredEvent(schemaDescriptor, schemaType);
        this.protoSchemaManager.onSchemaRegisteredEvent(event);
        ((ProtoSchemaAcceptor)Mockito.verify((Object)this.protoSchemaAcceptor)).accept((SchemaType)ArgumentMatchers.eq((Object)schemaType));
        ((Storage)Mockito.verify(this.protobufCache)).put((Object)((String)ArgumentMatchers.eq((Object)name)), (Object)((String)ArgumentMatchers.eq((Object)content)));
        ((Storage)Mockito.verify(this.processIdModelCache)).put((Object)((String)ArgumentMatchers.eq((Object)processId)), (Object)((String)ArgumentMatchers.eq((Object)processType)));
    }

    @Test
    void onSchemaRegisteredEventWithError() {
        String processId = "testProcessId";
        String processType = "testProcessType";
        ProcessDescriptor processDescriptor = new ProcessDescriptor(processId, processType);
        String name = "testName";
        String content = "testContent";
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(name, content, null, processDescriptor);
        SchemaType schemaType = new SchemaType("proto");
        SchemaRegisteredEvent event = new SchemaRegisteredEvent(schemaDescriptor, schemaType);
        Mockito.when((Object)this.protobufCache.containsKey((Object)((String)ArgumentMatchers.eq((Object)".errors")))).thenReturn((Object)true);
        Mockito.when((Object)((String)this.protobufCache.get((Object)((String)ArgumentMatchers.eq((Object)".errors"))))).thenReturn((Object)"testError");
        Assertions.assertThrows(SchemaRegistrationException.class, () -> this.protoSchemaManager.onSchemaRegisteredEvent(event));
        ((ProtoSchemaAcceptor)Mockito.verify((Object)this.protoSchemaAcceptor)).accept((SchemaType)ArgumentMatchers.eq((Object)schemaType));
        ((Storage)Mockito.verify(this.protobufCache)).put((Object)((String)ArgumentMatchers.eq((Object)name)), (Object)((String)ArgumentMatchers.eq((Object)content)));
        ((Storage)Mockito.verify(this.processIdModelCache)).put((Object)((String)ArgumentMatchers.eq((Object)processId)), (Object)((String)ArgumentMatchers.eq((Object)processType)));
    }
}

