/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.cache;

import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.JsonObject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.infinispan.cache.JsonDataFormatMarshaller;
import org.kie.kogito.index.model.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InfinispanCacheManager
implements CacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanCacheManager.class);
    private static final String PROCESS_INSTANCES_CACHE = "processinstances";
    private DataFormat jsonDataFormat = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new JsonDataFormatMarshaller()).build();
    @Inject
    @ConfigProperty(name="kogito.cache.domain.template", defaultValue="kogito-template")
    String domainCacheTemplate;
    @Inject
    RemoteCacheManager manager;

    @PostConstruct
    public void init() {
        this.manager.start();
    }

    @PreDestroy
    public void destroy() {
        this.manager.stop();
        try {
            this.manager.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Error trying to close Infinispan remote cache manager", (Throwable)ex);
        }
    }

    public Map<String, ProcessInstance> getProcessInstancesCache() {
        return this.manager.administration().getOrCreateCache(PROCESS_INSTANCES_CACHE, this.domainCacheTemplate);
    }

    public Map<String, JsonObject> getProcessInstancesCacheAsJson() {
        return this.manager.administration().getOrCreateCache(PROCESS_INSTANCES_CACHE, this.domainCacheTemplate).withDataFormat(this.jsonDataFormat);
    }

    public Map<String, String> getProtobufCache() {
        return this.manager.getCache("___protobuf_metadata");
    }

    public Map<String, String> getProcessIdModelCache() {
        return this.manager.administration().getOrCreateCache("processidmodel", (String)null);
    }

    public Map<String, JsonObject> getDomainModelCache(String processId) {
        return this.manager.administration().getOrCreateCache(processId + "_domain", this.domainCacheTemplate).withDataFormat(this.jsonDataFormat);
    }
}

