/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.index.infinispan.protostream.ProtobufService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProtobufMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufMonitorService.class);
    private static final PathMatcher protoFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.proto");
    @Inject
    @ConfigProperty(name="kogito.protobuf.folder")
    Optional<String> protoFiles;
    @Inject
    @ConfigProperty(name="kogito.protobuf.watch", defaultValue="false")
    Boolean monitor;
    @Inject
    ProtobufService protobufService;
    ExecutorService executorService;

    public void onStart(@Observes StartupEvent ev) {
        if (this.protoFiles.isPresent()) {
            String folderPath = this.protoFiles.get();
            File protoFolder = new File(folderPath);
            if (!protoFolder.exists()) {
                throw new RuntimeException(String.format("Could not find proto files folder at: %s", folderPath));
            }
            try (Stream<Path> stream = Files.find(protoFolder.toPath(), Integer.MAX_VALUE, (path, attrs) -> protoFileMatcher.matches((Path)path), new FileVisitOption[0]);){
                stream.forEach(path -> this.registerProtoFile().accept((Path)path));
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("Could not read content from proto file folder: %s", protoFolder), ex);
            }
            if (this.monitor.booleanValue()) {
                this.executorService = Executors.newSingleThreadExecutor();
                this.executorService.submit(new FolderWatcher(this.registerProtoFile(), protoFolder.toPath()));
            }
        }
    }

    private Consumer<Path> registerProtoFile() {
        return path -> {
            try {
                LOGGER.info("Found proto file: {}", path);
                String content = new String(Files.readAllBytes(path));
                this.protobufService.registerProtoBufferType(content);
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("Could not read content from proto file folder", new Object[0]), ex);
            }
            catch (Exception e) {
                LOGGER.error("Failed to register proto file: {}", path, (Object)e);
                throw new RuntimeException(e);
            }
        };
    }

    void onStop(@Observes ShutdownEvent ev) {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private class FolderWatcher
    implements Runnable {
        private Consumer<Path> consumer;
        private Path folder;

        public FolderWatcher(Consumer<Path> consumer, Path folder) {
            this.consumer = consumer;
            this.folder = folder;
        }

        @Override
        public void run() {
            try (WatchService ws = FileSystems.getDefault().newWatchService();){
                WatchKey key;
                this.folder.register(ws, StandardWatchEventKinds.ENTRY_MODIFY);
                while ((key = ws.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        LOGGER.debug("Event kind: {}. File affected: {}", event.kind(), event.context());
                        Path path = (Path)event.context();
                        if (!protoFileMatcher.matches(path)) continue;
                        Path proto = this.folder.resolve(path);
                        this.consumer.accept(proto);
                    }
                    key.reset();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Exception in proto folder watcher for folder: {}, message: {}", new Object[]{this.folder, ex.getMessage(), ex});
            }
        }
    }
}

