/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.infinispan.protostream.FileDescriptorRegisteredEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProtobufService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufService.class);
    @Inject
    CacheService manager;
    @Inject
    FileDescriptorSource kogitoDescriptors;
    @Inject
    Event<FileDescriptorRegisteredEvent> event;

    @PostConstruct
    public void init() {
        this.kogitoDescriptors.getFileDescriptors().forEach((name, bytes) -> {
            LOGGER.info("Registering Kogito ProtoBuffer file: {}", name);
            this.manager.getProtobufCache().put(name, new String((char[])bytes));
        });
    }

    public void registerProtoBufferType(String content) throws Exception {
        Descriptor descriptor;
        LOGGER.debug("Registering new ProtoBuffer file with content: \n{}", (Object)content);
        content = content.replaceAll("kogito.Date", "string");
        SerializationContextImpl ctx = new SerializationContextImpl(Configuration.builder().build());
        try {
            ctx.registerProtoFiles(this.kogitoDescriptors);
            ctx.registerProtoFiles(FileDescriptorSource.fromString((String)"", (String)content));
        }
        catch (Exception ex) {
            LOGGER.warn("Error trying to parse proto buffer file: {}", (Object)ex.getMessage(), (Object)ex);
            throw ex;
        }
        FileDescriptor desc = (FileDescriptor)ctx.getFileDescriptors().get("");
        Option processIdOption = desc.getOption("kogito_id");
        if (processIdOption == null || processIdOption.getValue() == null) {
            throw new Exception("Missing marker for process id in proto file, please add option kogito_id=\"processid\"");
        }
        String processId = (String)processIdOption.getValue();
        Option model = desc.getOption("kogito_model");
        if (model == null || model.getValue() == null) {
            throw new Exception("Missing marker for main message type in proto file, please add option kogito_model=\"messagename\"");
        }
        String messageName = (String)model.getValue();
        String fullTypeName = desc.getPackage() == null ? messageName : desc.getPackage() + "." + messageName;
        try {
            descriptor = ctx.getMessageDescriptor(fullTypeName);
        }
        catch (IllegalArgumentException ex) {
            throw new Exception(String.format("Could not find message with name: %s in proto file, e, please review option kogito_model", fullTypeName));
        }
        FieldDescriptor processInstances = descriptor.findFieldByName("processInstances");
        if (processInstances == null) {
            throw new Exception(String.format("Could not find processInstances attribute in proto message: %s", messageName));
        }
        Map cache = this.manager.getProtobufCache();
        cache.put(processId + ".proto", content);
        this.manager.getProcessIdModelCache().put(processId, fullTypeName);
        List<String> errors = this.checkSchemaErrors(cache);
        if (!errors.isEmpty()) {
            String message = "Proto Schema contain errors:\n" + errors.stream().collect(Collectors.joining("\n"));
            throw new Exception(message);
        }
        this.event.fire((Object)new FileDescriptorRegisteredEvent(desc));
        if (LOGGER.isDebugEnabled()) {
            this.listProtoCacheKeys();
        }
    }

    private void listProtoCacheKeys() {
        LOGGER.debug(">>>>>>list cache keys start");
        this.manager.getProtobufCache().entrySet().forEach(e -> LOGGER.debug(e.toString()));
        LOGGER.debug(">>>>>>list cache keys end");
    }

    private List<String> checkSchemaErrors(Map<String, String> metadataCache) {
        if (metadataCache.containsKey(".errors")) {
            ArrayList<String> errors = new ArrayList<String>();
            String files = metadataCache.get(".errors");
            for (String fname : files.split("\n")) {
                String errorKey = fname + ".errors";
                String error = metadataCache.get(errorKey);
                LOGGER.warn("Found errors in Protobuf schema file: {}\n{}\n", (Object)fname, (Object)error);
                errors.add(String.format("Protobuf schema file: %s\n%s\n", fname, error));
            }
            return errors;
        }
        return Collections.emptyList();
    }
}

