/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.query;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.FilterConditionContextQueryBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.kie.kogito.index.infinispan.cache.InfinispanCacheManager;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.query.ProcessInstanceFilter;
import org.kie.kogito.index.query.QueryService;

@ApplicationScoped
public class InfinispanQueryService
implements QueryService {
    @Inject
    InfinispanCacheManager manager;

    public Collection<JsonObject> queryDomain(String domain, String query) {
        if (query == null) {
            return this.manager.getDomainModelCache(domain).values();
        }
        QueryFactory qf = Search.getQueryFactory((RemoteCache)((RemoteCache)this.manager.getDomainModelCache(domain)));
        Query q = qf.create(query);
        return q.list().stream().map(json -> Json.createReader((Reader)new StringReader((String)json)).readObject()).collect(Collectors.toList());
    }

    public Collection<JsonObject> queryProcessInstances(ProcessInstanceFilter filter) {
        QueryFactory qf = Search.getQueryFactory((RemoteCache)((RemoteCache)this.manager.getProcessInstancesCache()));
        QueryBuilder qb = qf.from(ProcessInstance.class);
        if (filter != null) {
            FilterConditionContextQueryBuilder filterBuilder = null;
            if (filter.getState() != null && !filter.getState().isEmpty()) {
                filterBuilder = qb.having("state").in((Collection)filter.getState());
            }
            if (filter.getProcessId() != null && !filter.getProcessId().isEmpty()) {
                Set processIds = filter.getProcessId().stream().map(String::toLowerCase).collect(Collectors.toSet());
                if (filterBuilder == null) {
                    filterBuilder = qb.having("processId").in(processIds);
                } else {
                    filterBuilder.and().having("processId").in(processIds);
                }
            }
            if (filter.getId() != null && !filter.getId().isEmpty()) {
                if (filterBuilder == null) {
                    qb.having("id").in((Collection)filter.getId());
                } else {
                    filterBuilder.and().having("id").in((Collection)filter.getId());
                }
            }
            if (filter.getLimit() != null) {
                qb.maxResults(filter.getLimit().intValue());
            }
            if (filter.getOffset() != null) {
                qb.startOffset((long)filter.getOffset().intValue());
            }
        }
        return qb.build().list();
    }
}

