/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.infinispan.protostream.ProtobufMonitorService;
import org.kie.kogito.index.infinispan.protostream.ProtobufService;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ProtobufMonitorServiceTest {
    @Mock
    ProtobufService protobufService;
    @InjectMocks
    ProtobufMonitorService protobufMonitorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadingAndUpdatingFiles() throws Exception {
        Path dir = null;
        try {
            dir = Files.createTempDirectory(this.getClass().getName(), new FileAttribute[0]);
            Path sub = Files.createDirectory(dir.resolve("proto"), new FileAttribute[0]);
            Files.createFile(dir.resolve("kogito-application.proto"), new FileAttribute[0]);
            Path file1 = Files.createFile(dir.resolve("test1.proto"), new FileAttribute[0]);
            Path file2 = Files.createFile(sub.resolve("test2.proto"), new FileAttribute[0]);
            CountDownLatch latch = new CountDownLatch(4);
            ((ProtobufService)Mockito.doAnswer(args -> {
                latch.countDown();
                if (latch.getCount() == 2L) {
                    Files.write(file2, "test".getBytes(), new OpenOption[0]);
                    Files.write(file1, "test".getBytes(), new OpenOption[0]);
                }
                return null;
            }).when((Object)this.protobufService)).registerProtoBufferType((String)ArgumentMatchers.any());
            this.protobufMonitorService.monitor = true;
            this.protobufMonitorService.protoFiles = Optional.of(dir.toAbsolutePath().toString());
            this.protobufMonitorService.onStart(null);
            latch.await(1L, TimeUnit.MINUTES);
            Assertions.assertEquals((long)0L, (long)latch.getCount());
        }
        finally {
            if (dir != null) {
                try {
                    Files.deleteIfExists(dir);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

