/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.kie.kogito.index.cache.Cache;
import org.kie.kogito.index.infinispan.listener.CacheObjectCreatedListener;
import org.kie.kogito.index.infinispan.listener.CacheObjectRemovedListener;
import org.kie.kogito.index.infinispan.listener.CacheObjectUpdatedListener;
import org.kie.kogito.index.infinispan.query.InfinispanQuery;
import org.kie.kogito.index.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImpl<K, V>
implements Cache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheImpl.class);
    private RemoteCache<K, V> delegate;
    private String rootType;

    public CacheImpl(RemoteCache<K, V> delegate, String rootType) {
        this.delegate = delegate;
        this.rootType = rootType;
    }

    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.delegate.getOrDefault(key, defaultValue);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.delegate.forEach(action);
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.delegate.putIfAbsent(key, value);
    }

    public V replace(K key, V value) {
        return (V)this.delegate.replace(key, value);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.delegate.replaceAll(function);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.delegate.computeIfAbsent(key, mappingFunction);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.delegate.computeIfPresent(key, remappingFunction);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.delegate.compute(key, remappingFunction);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.delegate.merge(key, value, remappingFunction);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public V remove(Object key) {
        return (V)this.delegate.remove(key);
    }

    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    public V put(K key, V value) {
        return (V)this.delegate.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    public Collection<V> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public void addObjectCreatedListener(Consumer<V> consumer) {
        LOGGER.debug("Adding new object created listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectCreatedListener<K, V>(this.delegate, consumer));
    }

    public void addObjectUpdatedListener(Consumer<V> consumer) {
        LOGGER.debug("Adding new object updated listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectUpdatedListener<K, V>(this.delegate, consumer));
    }

    public void addObjectRemovedListener(Consumer<K> consumer) {
        LOGGER.debug("Adding new object removed listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectRemovedListener<K>(consumer));
    }

    public RemoteCache<K, V> getDelegate() {
        return this.delegate;
    }

    public String getRootType() {
        return this.rootType;
    }

    public Query<V> query() {
        return new InfinispanQuery<V>(this.delegate, this.rootType);
    }
}

