/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class CommentMarshaller
extends AbstractMarshaller
implements MessageMarshaller<Comment> {
    protected static final String ID = "id";
    protected static final String CONTENT = "content";
    protected static final String UPDATED_BY = "updatedBy";
    protected static final String UPDATED_AT = "updatedAt";

    public CommentMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public Comment readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        Comment comment = new Comment();
        comment.setId(reader.readString(ID));
        comment.setContent(reader.readString(CONTENT));
        comment.setUpdatedBy(reader.readString(UPDATED_BY));
        comment.setUpdatedAt(this.dateToZonedDateTime(reader.readDate(UPDATED_AT)));
        return comment;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Comment comment) throws IOException {
        writer.writeString(ID, comment.getId());
        writer.writeString(CONTENT, comment.getContent());
        writer.writeString(UPDATED_BY, comment.getUpdatedBy());
        writer.writeDate(UPDATED_AT, this.zonedDateTimeToDate(comment.getUpdatedAt()));
    }

    public Class<? extends Comment> getJavaClass() {
        return Comment.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

