/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.infinispan.protostream.MessageMarshaller;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.infinispan.protostream.UserTaskInstanceMarshaller;
import org.kie.kogito.index.model.UserTaskInstance;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class UserTaskInstanceMarshallerTest {
    private static ObjectMapper MAPPER = new ObjectMapper();
    private static UserTaskInstance TASK = new UserTaskInstance();

    UserTaskInstanceMarshallerTest() {
    }

    @BeforeAll
    static void setup() {
        TASK.setId("id");
        TASK.setDescription("description");
        TASK.setName("name");
        TASK.setPriority("priority");
        TASK.setProcessInstanceId("processInstanceId");
        TASK.setProcessId("processId");
        TASK.setRootProcessInstanceId("rootProcessInstanceId");
        TASK.setRootProcessId("rootProcessId");
        TASK.setState("state");
        TASK.setActualOwner("actualOwner");
        TASK.setAdminUsers(Collections.singleton("admin"));
        TASK.setAdminGroups(Collections.singleton("admin"));
        TASK.setCompleted(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS));
        TASK.setStarted(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS));
        TASK.setExcludedUsers(Collections.singleton("admin"));
        TASK.setPotentialGroups(Collections.singleton("user"));
        TASK.setPotentialUsers(Collections.singleton("user"));
        TASK.setInputs((JsonNode)MAPPER.createObjectNode());
        TASK.setOutputs((JsonNode)MAPPER.createObjectNode());
        TASK.setReferenceName("referenceName");
        TASK.setLastUpdate(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS));
        TASK.setEndpoint("endpoint");
    }

    @Test
    void testReadFrom() throws IOException {
        MessageMarshaller.ProtoStreamReader reader = (MessageMarshaller.ProtoStreamReader)Mockito.mock(MessageMarshaller.ProtoStreamReader.class);
        UserTaskInstanceMarshaller marshaller = new UserTaskInstanceMarshaller(MAPPER);
        Mockito.when((Object)reader.readString("id")).thenReturn((Object)TASK.getId());
        Mockito.when((Object)reader.readString("description")).thenReturn((Object)TASK.getDescription());
        Mockito.when((Object)reader.readString("name")).thenReturn((Object)TASK.getName());
        Mockito.when((Object)reader.readString("priority")).thenReturn((Object)TASK.getPriority());
        Mockito.when((Object)reader.readString("processInstanceId")).thenReturn((Object)TASK.getProcessInstanceId());
        Mockito.when((Object)reader.readString("processId")).thenReturn((Object)TASK.getProcessId());
        Mockito.when((Object)reader.readString("rootProcessInstanceId")).thenReturn((Object)TASK.getRootProcessInstanceId());
        Mockito.when((Object)reader.readString("rootProcessId")).thenReturn((Object)TASK.getRootProcessId());
        Mockito.when((Object)reader.readString("state")).thenReturn((Object)TASK.getState());
        Mockito.when((Object)reader.readString("actualOwner")).thenReturn((Object)TASK.getActualOwner());
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"adminUsers"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)TASK.getAdminUsers());
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"adminGroups"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)TASK.getAdminGroups());
        Mockito.when((Object)reader.readDate("completed")).thenReturn((Object)marshaller.zonedDateTimeToDate(TASK.getCompleted()));
        Mockito.when((Object)reader.readDate("started")).thenReturn((Object)marshaller.zonedDateTimeToDate(TASK.getStarted()));
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"excludedUsers"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)TASK.getExcludedUsers());
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"potentialGroups"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)TASK.getPotentialGroups());
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"potentialUsers"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)TASK.getPotentialUsers());
        Mockito.when((Object)reader.readString("inputs")).thenReturn((Object)TASK.getInputs().toString());
        Mockito.when((Object)reader.readString("outputs")).thenReturn((Object)TASK.getOutputs().toString());
        Mockito.when((Object)reader.readString("referenceName")).thenReturn((Object)TASK.getReferenceName());
        Mockito.when((Object)reader.readDate("lastUpdate")).thenReturn((Object)marshaller.zonedDateTimeToDate(TASK.getLastUpdate()));
        Mockito.when((Object)reader.readString("endpoint")).thenReturn((Object)TASK.getEndpoint());
        UserTaskInstance task = marshaller.readFrom(reader);
        ((ObjectAssert)Assertions.assertThat((Object)task).isNotNull()).isEqualToIgnoringGivenFields((Object)TASK, new String[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{reader});
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("id");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("description");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("name");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("priority");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("processInstanceId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("processId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("rootProcessInstanceId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("rootProcessId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("state");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("actualOwner");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("adminGroups", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("adminUsers", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("completed");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("started");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("excludedUsers", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("potentialGroups", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("potentialUsers", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("inputs");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("outputs");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("referenceName");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("lastUpdate");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("endpoint");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
    }

    @Test
    void testWriteTo() throws IOException {
        MessageMarshaller.ProtoStreamWriter writer = (MessageMarshaller.ProtoStreamWriter)Mockito.mock(MessageMarshaller.ProtoStreamWriter.class);
        UserTaskInstanceMarshaller marshaller = new UserTaskInstanceMarshaller(null);
        marshaller.writeTo(writer, TASK);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{writer});
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("id", TASK.getId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("description", TASK.getDescription());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("name", TASK.getName());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("priority", TASK.getPriority());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("processInstanceId", TASK.getProcessInstanceId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("processId", TASK.getProcessId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("rootProcessInstanceId", TASK.getRootProcessInstanceId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("rootProcessId", TASK.getRootProcessId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("state", TASK.getState());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("actualOwner", TASK.getActualOwner());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("adminGroups", (Collection)TASK.getAdminGroups(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("adminUsers", (Collection)TASK.getAdminUsers(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("completed", marshaller.zonedDateTimeToDate(TASK.getCompleted()));
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("started", marshaller.zonedDateTimeToDate(TASK.getStarted()));
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("excludedUsers", (Collection)TASK.getExcludedUsers(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("potentialGroups", (Collection)TASK.getPotentialGroups(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("potentialUsers", (Collection)TASK.getPotentialUsers(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("inputs", TASK.getInputs().toString());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("outputs", TASK.getOutputs().toString());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("referenceName", TASK.getReferenceName());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("lastUpdate", marshaller.zonedDateTimeToDate(TASK.getLastUpdate()));
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("endpoint", TASK.getEndpoint());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{writer});
    }

    @Test
    void testMarshaller() {
        UserTaskInstanceMarshaller marshaller = new UserTaskInstanceMarshaller(null);
        Assertions.assertThat((Class)marshaller.getJavaClass()).isEqualTo(UserTaskInstance.class);
        Assertions.assertThat((String)marshaller.getTypeName()).isEqualTo(UserTaskInstance.class.getName());
    }
}

