/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.infinispan.protostream.MessageMarshaller;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.infinispan.protostream.ProcessInstanceMarshaller;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class ProcessInstanceMarshallerTest {
    ProcessInstanceMarshallerTest() {
    }

    @Test
    void testReadFrom() throws IOException {
        Date now = new Date();
        MessageMarshaller.ProtoStreamReader reader = (MessageMarshaller.ProtoStreamReader)Mockito.mock(MessageMarshaller.ProtoStreamReader.class);
        Mockito.when((Object)reader.readString("id")).thenReturn((Object)"id");
        Mockito.when((Object)reader.readString("processId")).thenReturn((Object)"processId");
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"roles"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn(new HashSet<String>(Collections.singleton("admin")));
        Mockito.when((Object)reader.readString("variables")).thenReturn(null);
        Mockito.when((Object)reader.readString("endpoint")).thenReturn((Object)"endpoint");
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"nodes"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(NodeInstance.class))).thenReturn(new ArrayList());
        Mockito.when((Object)reader.readInt("state")).thenReturn((Object)1);
        Mockito.when((Object)reader.readDate("start")).thenReturn((Object)now);
        Mockito.when((Object)reader.readDate("end")).thenReturn((Object)now);
        Mockito.when((Object)reader.readString("rootProcessInstanceId")).thenReturn((Object)"rootProcessInstanceId");
        Mockito.when((Object)reader.readString("rootProcessId")).thenReturn((Object)"rootProcessId");
        Mockito.when((Object)reader.readString("parentProcessInstanceId")).thenReturn((Object)"parentProcessInstanceId");
        Mockito.when((Object)reader.readString("processName")).thenReturn((Object)"processName");
        Mockito.when((Object)((ProcessInstanceError)reader.readObject("error", ProcessInstanceError.class))).thenReturn(null);
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"addons"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn(new HashSet<String>(Collections.singleton("process-management")));
        Mockito.when((Object)reader.readDate("lastUpdate")).thenReturn((Object)now);
        Mockito.when((Object)reader.readString("businessKey")).thenReturn((Object)"businessKey");
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"milestones"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(Milestone.class))).thenReturn(new ArrayList());
        ProcessInstanceMarshaller marshaller = new ProcessInstanceMarshaller(null);
        ProcessInstance pi = marshaller.readFrom(reader);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pi).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"id")).hasFieldOrPropertyWithValue("processId", (Object)"processId")).hasFieldOrPropertyWithValue("roles", Collections.singleton("admin"))).hasFieldOrPropertyWithValue("variables", null)).hasFieldOrPropertyWithValue("endpoint", (Object)"endpoint")).hasFieldOrPropertyWithValue("nodes", Collections.emptyList())).hasFieldOrPropertyWithValue("state", (Object)1)).hasFieldOrPropertyWithValue("start", (Object)marshaller.dateToZonedDateTime(now))).hasFieldOrPropertyWithValue("end", (Object)marshaller.dateToZonedDateTime(now))).hasFieldOrPropertyWithValue("rootProcessInstanceId", (Object)"rootProcessInstanceId")).hasFieldOrPropertyWithValue("rootProcessId", (Object)"rootProcessId")).hasFieldOrPropertyWithValue("parentProcessInstanceId", (Object)"parentProcessInstanceId")).hasFieldOrPropertyWithValue("processName", (Object)"processName")).hasFieldOrPropertyWithValue("addons", Collections.singleton("process-management"))).hasFieldOrPropertyWithValue("error", null)).hasFieldOrPropertyWithValue("lastUpdate", (Object)marshaller.dateToZonedDateTime(now))).hasFieldOrPropertyWithValue("businessKey", (Object)"businessKey")).hasFieldOrPropertyWithValue("milestones", Collections.emptyList());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{reader});
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("id");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("processId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("roles", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("variables");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("endpoint");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("nodes", new ArrayList(), NodeInstance.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readInt("state");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("start");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("end");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("rootProcessInstanceId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("rootProcessId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("parentProcessInstanceId");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("processName");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readObject("error", ProcessInstanceError.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("addons", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("lastUpdate");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("businessKey");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("milestones", new ArrayList(), Milestone.class);
    }

    @Test
    void testWriteTo() throws IOException {
        ProcessInstance pi = new ProcessInstance();
        pi.setId("id");
        pi.setEndpoint("endpoint");
        pi.setProcessId("processId");
        pi.setProcessName("processName");
        pi.setRootProcessInstanceId("rootProcessInstanceId");
        pi.setParentProcessInstanceId("rootProcessInstanceId");
        pi.setRootProcessId("rootProcessId");
        pi.setRoles(Collections.singleton("admin"));
        pi.setVariables(null);
        pi.setNodes(Collections.emptyList());
        pi.setState(Integer.valueOf(ProcessInstanceState.ERROR.ordinal()));
        pi.setStart(ZonedDateTime.now());
        pi.setError(new ProcessInstanceError("StartEvent_1", "Something went wrong"));
        pi.setMilestones(Collections.emptyList());
        MessageMarshaller.ProtoStreamWriter writer = (MessageMarshaller.ProtoStreamWriter)Mockito.mock(MessageMarshaller.ProtoStreamWriter.class);
        ProcessInstanceMarshaller marshaller = new ProcessInstanceMarshaller(null);
        marshaller.writeTo(writer, pi);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{writer});
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("id", pi.getId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("processId", pi.getProcessId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("roles", (Collection)pi.getRoles(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("variables", null);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("endpoint", pi.getEndpoint());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("nodes", (Collection)pi.getNodes(), NodeInstance.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeInt("state", pi.getState());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("start", marshaller.zonedDateTimeToDate(pi.getStart()));
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("end", marshaller.zonedDateTimeToDate(pi.getEnd()));
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("rootProcessInstanceId", pi.getRootProcessInstanceId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("rootProcessId", pi.getRootProcessId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("parentProcessInstanceId", pi.getParentProcessInstanceId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("processName", pi.getProcessName());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeObject("error", (Object)pi.getError(), ProcessInstanceError.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("addons", (Collection)pi.getAddons(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("lastUpdate", marshaller.zonedDateTimeToDate(pi.getLastUpdate()));
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("businessKey", pi.getBusinessKey());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("milestones", (Collection)pi.getMilestones(), Milestone.class);
    }
}

