/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.infinispan.protostream.MessageMarshaller;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.infinispan.protostream.CommentMarshaller;
import org.kie.kogito.index.model.Comment;
import org.mockito.InOrder;
import org.mockito.Mockito;

class CommentMarshallerTest {
    String id = UUID.randomUUID().toString();
    String content = "CommentContent";
    String updatedBy = "CommentUpdatedBy";
    Date now = new Date();

    CommentMarshallerTest() {
    }

    @Test
    void testReadFrom() throws IOException {
        MessageMarshaller.ProtoStreamReader reader = (MessageMarshaller.ProtoStreamReader)Mockito.mock(MessageMarshaller.ProtoStreamReader.class);
        Mockito.when((Object)reader.readString("id")).thenReturn((Object)this.id);
        Mockito.when((Object)reader.readString("content")).thenReturn((Object)this.content);
        Mockito.when((Object)reader.readString("updatedBy")).thenReturn((Object)this.updatedBy);
        Mockito.when((Object)reader.readDate("updatedAt")).thenReturn((Object)this.now);
        CommentMarshaller commentMarshaller = new CommentMarshaller(null);
        Comment comment = commentMarshaller.readFrom(reader);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)comment).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)this.id)).hasFieldOrPropertyWithValue("content", (Object)this.content)).hasFieldOrPropertyWithValue("updatedBy", (Object)this.updatedBy)).hasFieldOrPropertyWithValue("updatedAt", (Object)commentMarshaller.dateToZonedDateTime(this.now));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{reader});
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("id");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("content");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("updatedBy");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("updatedAt");
    }

    @Test
    void testWriteTo() throws IOException {
        MessageMarshaller.ProtoStreamWriter writer = (MessageMarshaller.ProtoStreamWriter)Mockito.mock(MessageMarshaller.ProtoStreamWriter.class);
        CommentMarshaller marshaller = new CommentMarshaller(null);
        Comment comment = Comment.builder().id(this.id).content(this.content).updatedBy(this.updatedBy).updatedAt(marshaller.dateToZonedDateTime(this.now)).build();
        marshaller.writeTo(writer, comment);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{writer});
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("id", this.id);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("content", this.content);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("updatedBy", this.updatedBy);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("updatedAt", this.now);
    }

    @Test
    void testMarshaller() {
        CommentMarshaller marshaller = new CommentMarshaller(null);
        Assertions.assertThat((Class)marshaller.getJavaClass()).isEqualTo(Comment.class);
        Assertions.assertThat((String)marshaller.getTypeName()).isEqualTo(Comment.class.getName());
    }
}

