/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.io.IOException;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.infinispan.protostream.MessageMarshaller;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.infinispan.protostream.MilestoneMarshaller;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.MilestoneStatus;
import org.mockito.InOrder;
import org.mockito.Mockito;

class MilestoneMarshallerTest {
    String id = UUID.randomUUID().toString();
    String name = "SimpleMilestone";
    String status = MilestoneStatus.AVAILABLE.name();

    MilestoneMarshallerTest() {
    }

    @Test
    void testReadFrom() throws IOException {
        MessageMarshaller.ProtoStreamReader reader = (MessageMarshaller.ProtoStreamReader)Mockito.mock(MessageMarshaller.ProtoStreamReader.class);
        Mockito.when((Object)reader.readString("id")).thenReturn((Object)this.id);
        Mockito.when((Object)reader.readString("name")).thenReturn((Object)this.name);
        Mockito.when((Object)reader.readString("status")).thenReturn((Object)this.status);
        Milestone milestone = new MilestoneMarshaller(null).readFrom(reader);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)milestone).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)this.id)).hasFieldOrPropertyWithValue("name", (Object)this.name)).hasFieldOrPropertyWithValue("status", (Object)this.status);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{reader});
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("id");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("name");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("status");
    }

    @Test
    void testWriteTo() throws IOException {
        Milestone milestone = Milestone.builder().id(this.id).name(this.name).status(this.status).build();
        MessageMarshaller.ProtoStreamWriter writer = (MessageMarshaller.ProtoStreamWriter)Mockito.mock(MessageMarshaller.ProtoStreamWriter.class);
        new MilestoneMarshaller(null).writeTo(writer, milestone);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{writer});
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("id", this.id);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("name", this.name);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("status", this.status);
    }

    @Test
    void testMarshaller() {
        MilestoneMarshaller marshaller = new MilestoneMarshaller(null);
        Assertions.assertThat((Class)marshaller.getJavaClass()).isEqualTo(Milestone.class);
        Assertions.assertThat((String)marshaller.getTypeName()).isEqualTo(Milestone.class.getName());
    }
}

