/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class NodeInstanceMarshaller
extends AbstractMarshaller
implements MessageMarshaller<NodeInstance> {
    public NodeInstanceMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public NodeInstance readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        NodeInstance node = new NodeInstance();
        node.setId(reader.readString("id"));
        node.setName(reader.readString("name"));
        node.setType(reader.readString("type"));
        node.setEnter(this.dateToZonedDateTime(reader.readDate("enter")));
        node.setExit(this.dateToZonedDateTime(reader.readDate("exit")));
        node.setDefinitionId(reader.readString("definitionId"));
        node.setNodeId(reader.readString("nodeId"));
        return node;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, NodeInstance node) throws IOException {
        writer.writeString("id", node.getId());
        writer.writeString("name", node.getName());
        writer.writeString("type", node.getType());
        writer.writeDate("enter", this.zonedDateTimeToDate(node.getEnter()));
        writer.writeDate("exit", this.zonedDateTimeToDate(node.getExit()));
        writer.writeString("definitionId", node.getDefinitionId());
        writer.writeString("nodeId", node.getNodeId());
    }

    public Class<? extends NodeInstance> getJavaClass() {
        return NodeInstance.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

