/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.infinispan.protostream.MessageMarshaller;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.infinispan.protostream.AttachmentMarshaller;
import org.kie.kogito.index.model.Attachment;
import org.mockito.InOrder;
import org.mockito.Mockito;

class AttachmentMarshallerTest {
    String id = UUID.randomUUID().toString();
    String name = "AttachmentName";
    String content = "AttachmentContent";
    String updatedBy = "AttachmentUpdatedBy";
    Date now = new Date();

    AttachmentMarshallerTest() {
    }

    @Test
    void testReadFrom() throws IOException {
        MessageMarshaller.ProtoStreamReader reader = (MessageMarshaller.ProtoStreamReader)Mockito.mock(MessageMarshaller.ProtoStreamReader.class);
        Mockito.when((Object)reader.readString("id")).thenReturn((Object)this.id);
        Mockito.when((Object)reader.readString("name")).thenReturn((Object)this.name);
        Mockito.when((Object)reader.readString("content")).thenReturn((Object)this.content);
        Mockito.when((Object)reader.readString("updatedBy")).thenReturn((Object)this.updatedBy);
        Mockito.when((Object)reader.readDate("updatedAt")).thenReturn((Object)this.now);
        AttachmentMarshaller attachmentMarshaller = new AttachmentMarshaller(null);
        Attachment attachment = attachmentMarshaller.readFrom(reader);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)attachment).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)this.id)).hasFieldOrPropertyWithValue("name", (Object)this.name)).hasFieldOrPropertyWithValue("content", (Object)this.content)).hasFieldOrPropertyWithValue("updatedBy", (Object)this.updatedBy)).hasFieldOrPropertyWithValue("updatedAt", (Object)attachmentMarshaller.dateToZonedDateTime(this.now));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{reader});
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("id");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("name");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("content");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("updatedBy");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readDate("updatedAt");
    }

    @Test
    void testWriteTo() throws IOException {
        MessageMarshaller.ProtoStreamWriter writer = (MessageMarshaller.ProtoStreamWriter)Mockito.mock(MessageMarshaller.ProtoStreamWriter.class);
        AttachmentMarshaller marshaller = new AttachmentMarshaller(null);
        Attachment attachment = Attachment.builder().id(this.id).name(this.name).content(this.content).updatedBy(this.updatedBy).updatedAt(marshaller.dateToZonedDateTime(this.now)).build();
        marshaller.writeTo(writer, attachment);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{writer});
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("id", this.id);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("name", this.name);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("content", this.content);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("updatedBy", this.updatedBy);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeDate("updatedAt", this.now);
    }

    @Test
    void testMarshaller() {
        AttachmentMarshaller marshaller = new AttachmentMarshaller(null);
        Assertions.assertThat((Class)marshaller.getJavaClass()).isEqualTo(Attachment.class);
        Assertions.assertThat((String)marshaller.getTypeName()).isEqualTo(Attachment.class.getName());
    }
}

