/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import java.util.Collections;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.DataIndexStorageService;
import org.kie.kogito.index.infinispan.schema.ProtoSchemaAcceptor;
import org.kie.kogito.index.infinispan.schema.ProtoSchemaManager;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.api.schema.SchemaRegistrationException;
import org.kie.kogito.persistence.api.schema.SchemaType;
import org.kie.kogito.persistence.infinispan.cache.ProtobufCacheService;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ProtoSchemaManagerTest {
    @Mock
    ProtoSchemaAcceptor protoSchemaAcceptor;
    @Mock
    DataIndexStorageService cacheManager;
    @Mock
    ProtobufCacheService protobufCacheService;
    @InjectMocks
    ProtoSchemaManager protoSchemaManager;
    @Mock
    Storage<String, String> protobufCache;
    @Mock
    Storage<String, String> processIdModelCache;
    @Mock
    Template cacheTemplate;
    @Mock
    TemplateInstance templateInstance;
    @Mock
    RemoteCacheManager manager;
    @Mock
    RemoteCacheManagerAdmin remoteCacheManagerAdmin;

    ProtoSchemaManagerTest() {
    }

    @BeforeEach
    void prepare() {
        Mockito.when((Object)this.protoSchemaAcceptor.accept((SchemaType)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.protobufCacheService.getProtobufCache()).thenReturn(this.protobufCache);
        Mockito.when((Object)this.cacheManager.getProcessIdModelCache()).thenReturn(this.processIdModelCache);
        Mockito.when((Object)this.cacheManager.getDomainModelCacheName((String)ArgumentMatchers.any())).thenAnswer(inv -> inv.getArgument(0).toString() + "_domain");
        Mockito.when((Object)this.cacheTemplate.data((String)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.templateInstance);
        Mockito.when((Object)this.templateInstance.data((String)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.templateInstance);
        Mockito.when((Object)this.manager.administration()).thenReturn((Object)this.remoteCacheManagerAdmin);
    }

    @Test
    void onSchemaRegisteredEvent() {
        String processId = "testProcessId";
        String processType = "testProcessType";
        ProcessDescriptor processDescriptor = new ProcessDescriptor(processId, processType);
        String name = "testName";
        String content = "testContent";
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(name, content, Collections.emptyMap(), processDescriptor);
        SchemaType schemaType = new SchemaType("proto");
        SchemaRegisteredEvent event = new SchemaRegisteredEvent(schemaDescriptor, schemaType);
        this.protoSchemaManager.onSchemaRegisteredEvent(event);
        ((ProtoSchemaAcceptor)Mockito.verify((Object)this.protoSchemaAcceptor)).accept((SchemaType)ArgumentMatchers.eq((Object)schemaType));
        ((Storage)Mockito.verify(this.protobufCache)).put((Object)((String)ArgumentMatchers.eq((Object)name)), (Object)((String)ArgumentMatchers.eq((Object)content)));
        ((Storage)Mockito.verify(this.processIdModelCache)).put((Object)((String)ArgumentMatchers.eq((Object)processId)), (Object)((String)ArgumentMatchers.eq((Object)processType)));
        ((RemoteCacheManagerAdmin)Mockito.verify((Object)this.remoteCacheManagerAdmin)).getOrCreateCache((String)ArgumentMatchers.eq((Object)(processId + "_domain")), (BasicConfiguration)ArgumentMatchers.any(BasicConfiguration.class));
        ((DataIndexStorageService)Mockito.verify((Object)this.cacheManager)).getDomainModelCacheName(processId);
        ((Template)Mockito.verify((Object)this.cacheTemplate)).data("cache_name", (Object)(processId + "_domain"));
        ((TemplateInstance)Mockito.verify((Object)this.templateInstance)).data("indexed", Collections.emptySet());
    }

    @Test
    void onSchemaRegisteredEventWithError() {
        String processId = "testProcessId";
        String processType = "testProcessType";
        ProcessDescriptor processDescriptor = new ProcessDescriptor(processId, processType);
        String name = "testName";
        String content = "testContent";
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(name, content, Collections.emptyMap(), processDescriptor);
        SchemaType schemaType = new SchemaType("proto");
        SchemaRegisteredEvent event = new SchemaRegisteredEvent(schemaDescriptor, schemaType);
        Mockito.when((Object)this.protobufCache.containsKey((Object)((String)ArgumentMatchers.eq((Object)".errors")))).thenReturn((Object)true);
        Mockito.when((Object)((String)this.protobufCache.get((Object)((String)ArgumentMatchers.eq((Object)".errors"))))).thenReturn((Object)"testError");
        Assertions.assertThrows(SchemaRegistrationException.class, () -> this.protoSchemaManager.onSchemaRegisteredEvent(event));
        ((ProtoSchemaAcceptor)Mockito.verify((Object)this.protoSchemaAcceptor)).accept((SchemaType)ArgumentMatchers.eq((Object)schemaType));
        ((Storage)Mockito.verify(this.protobufCache)).put((Object)((String)ArgumentMatchers.eq((Object)name)), (Object)((String)ArgumentMatchers.eq((Object)content)));
        ((Storage)Mockito.verify(this.processIdModelCache)).put((Object)((String)ArgumentMatchers.eq((Object)processId)), (Object)((String)ArgumentMatchers.eq((Object)processType)));
    }
}

