/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.infinispan.protostream.MessageMarshaller;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.infinispan.protostream.ProcessDefinitionMarshaller;
import org.kie.kogito.index.model.ProcessDefinition;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class ProcessDefinitionMarshallerTest {
    ProcessDefinitionMarshallerTest() {
    }

    @Test
    void testReadFrom() throws IOException {
        MessageMarshaller.ProtoStreamReader reader = (MessageMarshaller.ProtoStreamReader)Mockito.mock(MessageMarshaller.ProtoStreamReader.class);
        Mockito.when((Object)reader.readString("id")).thenReturn((Object)"processId");
        Mockito.when((Object)reader.readString("version")).thenReturn((Object)"1.0");
        Mockito.when((Object)reader.readString("name")).thenReturn((Object)"processName");
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"roles"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn(new HashSet<String>(Collections.singleton("admin")));
        Mockito.when((Object)reader.readCollection((String)ArgumentMatchers.eq((Object)"addons"), (Collection)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn(new HashSet<String>(Collections.singleton("process-management")));
        Mockito.when((Object)reader.readString("type")).thenReturn((Object)"processType");
        ProcessDefinitionMarshaller marshaller = new ProcessDefinitionMarshaller(null);
        ProcessDefinition pd = marshaller.readFrom(reader);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pd).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"processId")).hasFieldOrPropertyWithValue("version", (Object)"1.0")).hasFieldOrPropertyWithValue("name", (Object)"processName")).hasFieldOrPropertyWithValue("roles", Collections.singleton("admin"))).hasFieldOrPropertyWithValue("addons", Collections.singleton("process-management"))).hasFieldOrPropertyWithValue("type", (Object)"processType");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{reader});
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("id");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("version");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("name");
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("roles", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readCollection("addons", new HashSet(), String.class);
        ((MessageMarshaller.ProtoStreamReader)inOrder.verify((Object)reader)).readString("type");
    }

    @Test
    void testWriteTo() throws IOException {
        ProcessDefinition pd = new ProcessDefinition();
        pd.setId("processId");
        pd.setVersion("1.0");
        pd.setName("processName");
        pd.setRoles(Collections.singleton("admin"));
        pd.setAddons(Collections.singleton("process-management"));
        pd.setType("processType");
        MessageMarshaller.ProtoStreamWriter writer = (MessageMarshaller.ProtoStreamWriter)Mockito.mock(MessageMarshaller.ProtoStreamWriter.class);
        ProcessDefinitionMarshaller marshaller = new ProcessDefinitionMarshaller(null);
        marshaller.writeTo(writer, pd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{writer});
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("id", pd.getId());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("version", pd.getVersion());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("name", pd.getName());
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("roles", (Collection)pd.getRoles(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeCollection("addons", (Collection)pd.getAddons(), String.class);
        ((MessageMarshaller.ProtoStreamWriter)inOrder.verify((Object)writer)).writeString("type", pd.getType());
    }
}

