/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class ProcessDefinitionMarshaller
extends AbstractMarshaller
implements MessageMarshaller<ProcessDefinition> {
    protected static final String ID = "id";
    protected static final String VERSION = "version";
    protected static final String NAME = "name";
    protected static final String ROLES = "roles";
    protected static final String ADDONS = "addons";
    protected static final String TYPE = "type";
    protected static final String ENDPOINT = "endpoint";

    public ProcessDefinitionMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public ProcessDefinition readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        ProcessDefinition pd = new ProcessDefinition();
        pd.setId(reader.readString(ID));
        pd.setVersion(reader.readString(VERSION));
        pd.setName(reader.readString(NAME));
        pd.setRoles((Set)reader.readCollection(ROLES, new HashSet(), String.class));
        pd.setAddons((Set)reader.readCollection(ADDONS, new HashSet(), String.class));
        pd.setType(reader.readString(TYPE));
        pd.setEndpoint(reader.readString(ENDPOINT));
        return pd;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, ProcessDefinition pd) throws IOException {
        writer.writeString(ID, pd.getId());
        writer.writeString(VERSION, pd.getVersion());
        writer.writeString(NAME, pd.getName());
        writer.writeCollection(ROLES, (Collection)pd.getRoles(), String.class);
        writer.writeCollection(ADDONS, (Collection)pd.getAddons(), String.class);
        writer.writeString(TYPE, pd.getType());
        writer.writeString(ENDPOINT, pd.getEndpoint());
    }

    public Class<? extends ProcessDefinition> getJavaClass() {
        return ProcessDefinition.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

