/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.io.impl.DescrResource;
import org.kie.api.io.Resource;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class KnowledgeBuilderUtil {
    public static PackageDescr drlToPackageDescr(Resource resource, List<KnowledgeBuilderResult> results) {
        try {
            return KnowledgeBuilderUtil.drlToPackageDescr(resource, null, results, DrlParser.DEFAULT_LANGUAGE_LEVEL);
        }
        catch (IOException | DroolsParserException e) {
            throw new RuntimeException(e);
        }
    }

    public static PackageDescr dtableToPackageDescr(Resource resource, List<KnowledgeBuilderResult> results) {
        String generatedDrl = DecisionTableFactory.loadFromResource(resource, (DecisionTableConfiguration)new DecisionTableConfigurationImpl());
        try {
            return KnowledgeBuilderUtil.drlToPackageDescr(resource, generatedDrl, results, DrlParser.DEFAULT_LANGUAGE_LEVEL);
        }
        catch (IOException | DroolsParserException e) {
            throw new RuntimeException(e);
        }
    }

    public static PackageDescr drlToPackageDescr(Resource resource, List<KnowledgeBuilderResult> results, LanguageLevelOption languageLevel) throws DroolsParserException, IOException {
        return KnowledgeBuilderUtil.drlToPackageDescr(resource, null, results, languageLevel);
    }

    public static PackageDescr drlToPackageDescr(Resource resource, String generatedDrl, List<KnowledgeBuilderResult> results, LanguageLevelOption languageLevel) throws DroolsParserException, IOException {
        PackageDescr pkg;
        boolean hasErrors = false;
        if (resource instanceof DescrResource) {
            pkg = (PackageDescr)((DescrResource)resource).getDescr();
        } else {
            DrlParser parser = new DrlParser(languageLevel);
            pkg = generatedDrl == null ? parser.parse(resource) : parser.parse(resource, (Reader)new StringReader(generatedDrl));
            results.addAll(parser.getErrors());
            hasErrors = parser.hasErrors();
        }
        if (pkg != null) {
            pkg.setResource(resource);
        }
        return hasErrors ? null : pkg;
    }
}

