/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.HashMap;
import java.util.Map;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;

public class KieModuleModelMethod {
    private static final String KMODULE_MODEL_NAME = "kModuleModel";
    private final String kieModuleModelCanonicalName = KieModuleModel.class.getCanonicalName();
    private final Map<String, KieBaseModel> kBaseModels;
    private BlockStmt stmt = new BlockStmt();
    private final Map<String, String> kSessionForkBase = new HashMap<String, String>();
    private final Map<String, BlockStmt> kBaseConfs = new HashMap<String, BlockStmt>();
    private final Map<String, BlockStmt> kSessionConfs = new HashMap<String, BlockStmt>();
    private String defaultKieBaseName;
    private String defaultKieSessionName;
    private String defaultKieStatelessSessionName;

    public KieModuleModelMethod(Map<String, KieBaseModel> kBaseModels) {
        this.kBaseModels = kBaseModels;
        this.init();
    }

    public String getConstructor() {
        StringBuilder sb = new StringBuilder("    private java.util.Map<String, KieBase> kbases = new java.util.HashMap<>();\n\n    public ProjectRuntime() {\n        ProjectModel model = new ProjectModel();\n        java.util.Map<String, KieBaseModel> kBaseModelMap = model.getKieModuleModel().getKieBaseModels();\n");
        this.kBaseModels.keySet().forEach(kBaseName -> sb.append("        kbases.put(\"" + kBaseName + "\", org.drools.modelcompiler.builder.KieBaseBuilder.createKieBaseFromModel( model.getModels(), kBaseModelMap.get( \"" + kBaseName + "\" ) ));\n"));
        sb.append("    }\n");
        return sb.toString();
    }

    public String toGetKieModuleModelMethod() {
        MethodDeclaration methodDeclaration = new MethodDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier()}), (Type)new ClassOrInterfaceType(null, this.kieModuleModelCanonicalName), "getKieModuleModel");
        methodDeclaration.setBody(this.stmt);
        methodDeclaration.addAnnotation("Override");
        return methodDeclaration.toString();
    }

    public String toNewKieSessionMethod() {
        return "    @Override\n    public KieSession newKieSession() {\n        return newKieSession(\"" + this.defaultKieSessionName + "\");\n    }\n\n    @Override\n    public KieSession newKieSession(String sessionName) {\n        return newKieSession(sessionName, new org.drools.core.config.StaticRuleConfig(new org.drools.core.config.DefaultRuleEventListenerConfig()));\n    }\n\n    @Override\n    public KieSession newKieSession(String sessionName, org.kie.kogito.rules.RuleConfig ruleConfig) {\n        return java.util.Optional.ofNullable(getKieBaseForSession(sessionName).newKieSession(getConfForSession(sessionName), null)).map(k -> {\nruleConfig.ruleEventListeners().agendaListeners().forEach( l -> k.addEventListener(l));\n            ruleConfig.ruleEventListeners().ruleRuntimeListeners().forEach( l -> k.addEventListener(l));\n            return k;\n        }).get();    }\n";
    }

    public String toGetKieBaseForSessionMethod() {
        StringBuilder sb = new StringBuilder("    private KieBase getKieBaseForSession(String sessionName) {\n        switch (sessionName) {\n");
        for (Map.Entry<String, String> entry : this.kSessionForkBase.entrySet()) {
            sb.append("            case \"" + entry.getKey() + "\": return kbases.get(\"" + entry.getValue() + "\");\n");
        }
        sb.append("        }\n        return null;\n    }\n");
        return sb.toString();
    }

    public String toKieSessionConfMethod() {
        StringBuilder sb = new StringBuilder("    private org.kie.api.runtime.KieSessionConfiguration getConfForSession(String sessionName) {\n        org.drools.core.SessionConfigurationImpl conf = new org.drools.core.SessionConfigurationImpl();\n        switch (sessionName) {\n");
        for (Map.Entry<String, BlockStmt> entry : this.kSessionConfs.entrySet()) {
            sb.append("            case \"" + entry.getKey() + "\":\n");
            sb.append(entry.getValue());
            sb.append("                break;\n");
        }
        sb.append("        }\n        return conf;\n    }\n");
        return sb.toString();
    }

    private void init() {
        this.stmt.addStatement(StaticJavaParser.parseStatement((String)String.format("%s %s = org.kie.api.KieServices.get().newKieModuleModel();", this.kieModuleModelCanonicalName, KMODULE_MODEL_NAME)));
        this.kBaseModels.values().forEach(kBaseModel -> new BaseModelGenerator((KieBaseModel)kBaseModel).toSourceCode());
        this.stmt.addStatement(StaticJavaParser.parseStatement((String)String.format("return %s;", KMODULE_MODEL_NAME)));
    }

    private void createEnum(BlockStmt stmt, Expression expr, String enumType, String enumName, String enumSetter) {
        String sessionType = enumType + "." + enumName;
        FieldAccessExpr sessionTypeEnum = (FieldAccessExpr)StaticJavaParser.parseExpression((String)sessionType);
        stmt.addStatement((Expression)new MethodCallExpr(expr, enumSetter, NodeList.nodeList((Node[])new Expression[]{sessionTypeEnum})));
    }

    private NameExpr moduleModelNameExpr() {
        return new NameExpr(KMODULE_MODEL_NAME);
    }

    private AssignExpr newInstance(String type, String variableName, NameExpr scope, String methodName, String parameter) {
        MethodCallExpr initMethod = new MethodCallExpr((Expression)scope, methodName, NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(parameter)}));
        VariableDeclarationExpr var = new VariableDeclarationExpr((Type)new ClassOrInterfaceType(null, type), variableName);
        return new AssignExpr((Expression)var, (Expression)initMethod, AssignExpr.Operator.ASSIGN);
    }

    private class SessionModelGenerator {
        private KieSessionModel kieSessionModel;
        private NameExpr kieBaseModelNameExpr;
        private String name;
        private NameExpr nameExpr;
        private final NameExpr confExpr;
        private final BlockStmt confBlock = new BlockStmt();

        private SessionModelGenerator(KieSessionModel kieSessionModel, NameExpr kieBaseModelNameExpr) {
            this.kieSessionModel = kieSessionModel;
            this.kieBaseModelNameExpr = kieBaseModelNameExpr;
            this.name = "kieSessionModel_" + kieSessionModel.getName();
            this.nameExpr = new NameExpr(this.name);
            this.confExpr = new NameExpr("conf");
            KieModuleModelMethod.this.kSessionConfs.put(kieSessionModel.getName(), this.confBlock);
        }

        void toSourceCode() {
            this.newSessionModelInstance();
            this.sessionDefault();
            this.setSessionModelType();
            this.setClockType();
        }

        private void newSessionModelInstance() {
            KieModuleModelMethod.this.stmt.addStatement((Expression)KieModuleModelMethod.this.newInstance(KieSessionModel.class.getName(), this.name, this.kieBaseModelNameExpr, "newKieSessionModel", this.kieSessionModel.getName()));
        }

        private void setSessionModelType() {
            KieSessionModel.KieSessionType type = this.kieSessionModel.getType();
            KieModuleModelMethod.this.createEnum(KieModuleModelMethod.this.stmt, (Expression)this.nameExpr, type.getClass().getCanonicalName(), type.toString(), "setType");
        }

        private void setClockType() {
            NameExpr type = new NameExpr(this.kieSessionModel.getClockType().getClass().getCanonicalName());
            MethodCallExpr clockTypeEnum = new MethodCallExpr((Expression)type, "get", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(this.kieSessionModel.getClockType().getClockType())}));
            KieModuleModelMethod.this.stmt.addStatement((Expression)new MethodCallExpr((Expression)this.nameExpr, "setClockType", NodeList.nodeList((Node[])new Expression[]{clockTypeEnum})));
            this.confBlock.addStatement((Expression)new MethodCallExpr((Expression)this.confExpr, "setOption", NodeList.nodeList((Node[])new Expression[]{clockTypeEnum.clone()})));
        }

        private void sessionDefault() {
            if (this.kieSessionModel.isDefault()) {
                if (this.kieSessionModel.getType() == KieSessionModel.KieSessionType.STATELESS) {
                    KieModuleModelMethod.this.defaultKieStatelessSessionName = this.kieSessionModel.getName();
                } else {
                    KieModuleModelMethod.this.defaultKieSessionName = this.kieSessionModel.getName();
                }
                KieModuleModelMethod.this.stmt.addStatement((Expression)new MethodCallExpr((Expression)this.nameExpr, "setDefault", NodeList.nodeList((Node[])new Expression[]{new BooleanLiteralExpr(true)})));
            }
        }
    }

    private class BaseModelGenerator {
        private final KieBaseModel kieBaseModel;
        private final String kieBaseModelName;
        private final NameExpr kieBaseModelNameExpr;
        private final NameExpr confExpr;
        private final BlockStmt confBlock = new BlockStmt();

        private BaseModelGenerator(KieBaseModel kieBaseModel) {
            this.kieBaseModel = kieBaseModel;
            this.kieBaseModelName = "kieBaseModel_" + kieBaseModel.getName();
            this.kieBaseModelNameExpr = new NameExpr(this.kieBaseModelName);
            this.confExpr = new NameExpr("conf");
            KieModuleModelMethod.this.kBaseConfs.put(kieBaseModel.getName(), this.confBlock);
        }

        void toSourceCode() {
            this.newBaseModelInstance();
            this.kieBaseModelDefault();
            this.eventProcessingType();
            this.kieBaseModelPackages();
            this.sessionModels();
        }

        private void newBaseModelInstance() {
            KieModuleModelMethod.this.stmt.addStatement((Expression)KieModuleModelMethod.this.newInstance(KieBaseModel.class.getName(), this.kieBaseModelName, KieModuleModelMethod.this.moduleModelNameExpr(), "newKieBaseModel", this.kieBaseModel.getName()));
        }

        private void kieBaseModelDefault() {
            if (this.kieBaseModel.isDefault()) {
                KieModuleModelMethod.this.defaultKieBaseName = this.kieBaseModel.getName();
                KieModuleModelMethod.this.stmt.addStatement((Expression)new MethodCallExpr((Expression)this.kieBaseModelNameExpr, "setDefault", NodeList.nodeList((Node[])new Expression[]{new BooleanLiteralExpr(true)})));
            }
        }

        private void eventProcessingType() {
            KieModuleModelMethod.this.createEnum(KieModuleModelMethod.this.stmt, (Expression)this.kieBaseModelNameExpr, this.kieBaseModel.getEventProcessingMode().getClass().getCanonicalName(), this.kieBaseModel.getEventProcessingMode().getMode().toUpperCase(), "setEventProcessingMode");
            KieModuleModelMethod.this.createEnum(this.confBlock, (Expression)this.confExpr, this.kieBaseModel.getEventProcessingMode().getClass().getCanonicalName(), this.kieBaseModel.getEventProcessingMode().getMode().toUpperCase(), "setEventProcessingMode");
        }

        void kieBaseModelPackages() {
            for (String p : this.kieBaseModel.getPackages()) {
                KieModuleModelMethod.this.stmt.addStatement((Expression)new MethodCallExpr((Expression)this.kieBaseModelNameExpr, "addPackage", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(p)})));
            }
        }

        private void sessionModels() {
            this.kieBaseModel.getKieSessionModels().values().forEach(kSessionModel -> {
                KieModuleModelMethod.this.kSessionForkBase.put(kSessionModel.getName(), this.kieBaseModel.getName());
                new SessionModelGenerator((KieSessionModel)kSessionModel, this.kieBaseModelNameExpr).toSourceCode();
            });
        }
    }
}

