/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.model.BitMask;
import org.drools.model.Drools;
import org.drools.model.DroolsEntryPoint;
import org.drools.modelcompiler.consequence.DroolsEntryPointImpl;
import org.drools.modelcompiler.util.EvaluationUtil;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleContext;

public class DroolsImpl
implements Drools,
RuleContext {
    private final KnowledgeHelper knowledgeHelper;
    private final WorkingMemory workingMemory;
    private final Map<Object, InternalFactHandle> fhLookup = new IdentityHashMap<Object, InternalFactHandle>();

    DroolsImpl(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.knowledgeHelper = knowledgeHelper;
    }

    public void insert(Object object) {
        this.workingMemory.insert(object);
    }

    public void insert(Object object, boolean dynamic) {
        this.workingMemory.insert(object, dynamic);
    }

    public Rule getRule() {
        return this.knowledgeHelper.getRule();
    }

    public Match getMatch() {
        return this.knowledgeHelper.getMatch();
    }

    public FactHandle insertLogical(Object object) {
        return this.knowledgeHelper.insertLogical(object);
    }

    public FactHandle insertLogical(Object object, Object value) {
        return this.knowledgeHelper.insertLogical(object, value);
    }

    public void blockMatch(Match match) {
        this.knowledgeHelper.blockMatch(match);
    }

    public void unblockAllMatches(Match match) {
        this.knowledgeHelper.unblockAllMatches(match);
    }

    public void cancelMatch(Match match) {
        this.knowledgeHelper.cancelMatch(match);
    }

    public void update(Object object, String ... modifiedProperties) {
        Class<?> modifiedClass = object.getClass();
        TypeDeclaration typeDeclaration = this.workingMemory.getKnowledgeBase().getOrCreateExactTypeDeclaration(modifiedClass);
        AllSetBitMask mask = typeDeclaration.isPropertyReactive() ? PropertySpecificUtil.calculatePositiveMask(modifiedClass, Arrays.asList(modifiedProperties), (List)typeDeclaration.getAccessibleProperties()) : AllSetBitMask.get();
        this.knowledgeHelper.update((FactHandle)this.getFactHandleForObject(object), (org.drools.core.util.bitmask.BitMask)mask, modifiedClass);
    }

    private InternalFactHandle getFactHandleForObject(Object object) {
        InternalFactHandle fh = this.fhLookup.get(object);
        return fh != null ? fh : (InternalFactHandle)this.workingMemory.getFactHandle(object);
    }

    public void update(Object object, BitMask modifiedProperties) {
        Class modifiedClass = modifiedProperties.getPatternClass();
        this.knowledgeHelper.update((FactHandle)this.getFactHandleForObject(object), EvaluationUtil.adaptBitMask(modifiedProperties), modifiedClass);
    }

    public void update(FactHandle handle, Object newObject) {
        this.knowledgeHelper.update(handle, newObject);
    }

    public void delete(Object object) {
        this.knowledgeHelper.delete((FactHandle)this.getFactHandleForObject(object));
    }

    void registerFactHandle(InternalFactHandle fh) {
        this.fhLookup.put(fh.getObject(), fh);
    }

    public <T> T getRuntime(Class<T> runtimeClass) {
        return (T)this.knowledgeHelper.getKieRuntime();
    }

    public DroolsEntryPoint getEntryPoint(String name) {
        return new DroolsEntryPointImpl(this.knowledgeHelper.getEntryPoint(name), this.fhLookup);
    }

    public void halt() {
        this.knowledgeHelper.halt();
    }

    public void setFocus(String focus) {
        this.knowledgeHelper.setFocus(focus);
    }

    public KieRuntime getKieRuntime() {
        return this.knowledgeHelper.getKieRuntime();
    }

    public KieRuntime getKnowledgeRuntime() {
        return this.knowledgeHelper.getKieRuntime();
    }

    public KnowledgeHelper asKnowledgeHelper() {
        return this.knowledgeHelper;
    }
}

