/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.Collection;
import java.util.Collections;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.model.Model;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.KiePackagesBuilder;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.conf.KieBaseOption;

public class KieBaseBuilder {
    private final String kBaseName;
    private final KieBaseConfiguration conf;

    public KieBaseBuilder() {
        this(null, null);
    }

    public KieBaseBuilder(KieBaseConfiguration conf) {
        this(null, conf);
    }

    public KieBaseBuilder(KieBaseModelImpl kBaseModel, KieBaseConfiguration conf) {
        this.conf = conf;
        this.kBaseName = kBaseModel != null ? kBaseModel.getName() : "defaultkiebase";
    }

    public InternalKnowledgeBase createKieBase(CanonicalKiePackages kpkgs) {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase((String)this.kBaseName, (KieBaseConfiguration)this.conf);
        kBase.addPackages(kpkgs.getKiePackages());
        return kBase;
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Model model, KieBaseOption ... options) {
        return KieBaseBuilder.createKieBaseFromModel(Collections.singleton(model), options);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Model model, KieBaseConfiguration kieBaseConf) {
        return KieBaseBuilder.createKieBaseFromModel(Collections.singleton(model), kieBaseConf);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Collection<Model> models, KieBaseOption ... options) {
        KieBaseConfiguration kieBaseConf = KieServices.get().newKieBaseConfiguration();
        if (options != null) {
            for (KieBaseOption option : options) {
                kieBaseConf.setOption(option);
            }
        }
        return KieBaseBuilder.createKieBaseFromModel(models, kieBaseConf);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Collection<Model> models, KieBaseConfiguration kieBaseConf) {
        KiePackagesBuilder builder = new KiePackagesBuilder(kieBaseConf);
        models.forEach(builder::addModel);
        return new KieBaseBuilder(kieBaseConf).createKieBase(builder.build());
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Collection<Model> models, KieBaseModel kieBaseModel) {
        RuleBaseConfiguration kieBaseConf = new RuleBaseConfiguration();
        kieBaseConf.setEventProcessingMode(kieBaseModel.getEventProcessingMode());
        KiePackagesBuilder builder = new KiePackagesBuilder((KieBaseConfiguration)kieBaseConf);
        models.stream().filter(m -> KieBuilderImpl.isPackageInKieBase((KieBaseModel)kieBaseModel, (String)m.getName())).forEach(builder::addModel);
        return new KieBaseBuilder((KieBaseConfiguration)kieBaseConf).createKieBase(builder.build());
    }
}

