/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.mvel.parser.DrlxParser;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ParseStart;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.DrlxExpression;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;
import org.drools.mvel.parser.ast.expr.HalfPointFreeExpr;
import org.drools.mvel.parser.ast.expr.OOPathChunk;
import org.drools.mvel.parser.ast.expr.OOPathExpr;
import org.drools.mvel.parser.ast.expr.PointFreeExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralChunkExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralExpr;
import org.drools.mvel.parser.printer.PrintUtil;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DroolsMvelParserTest {
    private static final Collection<String> operators = new HashSet<String>();
    final ParseStart<DrlxExpression> parser;

    public DroolsMvelParserTest() {
        operators.addAll(Arrays.asList("after", "before", "in", "matches", "includes"));
        this.parser = DrlxParser.buildDrlxParserWithArguments(operators);
    }

    @Test
    public void testParseSimpleExpr() {
        String expr = "name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name", (Object)this.toString((Node)binaryExpr.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)binaryExpr.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
    }

    @Test
    public void testBinaryWithNewLine() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 ||\n                   addresses == 3  )").getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 &&\n addresses == 3  )").getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and));
    }

    @Test
    public void testBinaryWithWindowsNewLine() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 ||\r\n                   addresses == 3  )").getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or));
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 &&\r\n addresses == 3  )").getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and));
    }

    @Test
    public void testBinaryWithNewLineBeginning() {
        org.junit.jupiter.api.Assertions.assertThrows(ParseProblemException.class, () -> {
            Expression or = DrlxParser.parseExpression(this.parser, (String)("(" + System.lineSeparator() + "addresses == 2 || addresses == 3  )")).getExpr();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or));
            Expression and = DrlxParser.parseExpression(this.parser, (String)("(" + System.lineSeparator() + "addresses == 2 && addresses == 3  )")).getExpr();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and));
        });
    }

    @Test
    public void testBinaryWithNewLineEnd() {
        org.junit.jupiter.api.Assertions.assertThrows(ParseProblemException.class, () -> {
            Expression or = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2 || addresses == 3 " + System.lineSeparator() + ")")).getExpr();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or));
            Expression and = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2 && addresses == 3  " + System.lineSeparator() + ")")).getExpr();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and));
        });
    }

    @Test
    @Disabled
    public void testBinaryWithNewLineBeforeOperator() {
        Expression and2 = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2" + System.lineSeparator() + "&& addresses == 3  )")).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 && addresses == 3)", (Object)PrintUtil.printConstraint((Node)and2));
        Expression or2 = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2" + System.lineSeparator() + "|| addresses == 3  )")).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(addresses == 2 || addresses == 3)", (Object)PrintUtil.printConstraint((Node)or2));
    }

    @Test
    public void testParseSafeCastExpr() {
        String expr = "this instanceof Person && ((Person) this).name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testParseInlineCastExpr() {
        String expr = "this#Person.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testParseNullSafeFieldAccessExpr() {
        String expr = "person!.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExpr() {
        String expr = "this after $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof PointFreeExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeEnclosed() {
        String expr = "(this after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeEnclosedWithNameExpr() {
        String expr = "(something after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testLiteral() {
        String bigDecimalLiteral = "bigInteger < (50B)";
        Expression bigDecimalExpr = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteral).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)bigDecimalLiteral, (Object)PrintUtil.printConstraint((Node)bigDecimalExpr));
        String bigIntegerLiteral = "bigInteger == (50I)";
        Expression bigIntegerExpr = DrlxParser.parseExpression(this.parser, (String)bigIntegerLiteral).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)bigIntegerLiteral, (Object)PrintUtil.printConstraint((Node)bigIntegerExpr));
    }

    @Test
    public void testBigDecimalLiteral() {
        String bigDecimalLiteralWithDecimals = "12.111B";
        Expression bigDecimalExprWithDecimals = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteralWithDecimals).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)bigDecimalLiteralWithDecimals, (Object)PrintUtil.printConstraint((Node)bigDecimalExprWithDecimals));
    }

    @Test
    public void testDotFreeExprWithOr() {
        String expr = "this after $a || this after $b";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof BinaryExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgs() {
        String expr = "this after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof PointFreeExpr));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"this after[5ms,8ms] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsInfinite() {
        String expr = "this after[5s,*] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof PointFreeExpr));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"this after[5s,*] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithThreeArgsInfinite() {
        String expr = "this after[*,*,*,2s] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof PointFreeExpr));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"this after[*,*,*,2s] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsNegated() {
        String expr = "this not after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(PointFreeExpr.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((PointFreeExpr)expression).isNegated());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"this not after[5ms,8ms] $a", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithTemporalArgs() {
        String expr = "this after[5ms,8d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof PointFreeExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testDotFreeExprWithFourTemporalArgs() {
        String expr = "this includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof PointFreeExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testHalfDotFreeExprWithFourTemporalArgs() {
        String expr = "includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(HalfPointFreeExpr.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testInvalidTemporalArgs() {
        org.junit.jupiter.api.Assertions.assertThrows(ParseProblemException.class, () -> {
            String expr = "this after[5ms,8f] $a";
            Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        });
    }

    @Test
    public void testOOPathExpr() {
        String expr = "/wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof OOPathExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testOOPathExprWithMultipleCondition() {
        String expr = "$address : /address[street == \"Elm\",city == \"Big City\"]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof OOPathExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testOOPathExprWithDeclaration() {
        String expr = "$toy : /wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof OOPathExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testOOPathExprWithBackReference() {
        String expr = "$toy : /wife/children/toys[name.length == ../../name.length]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof OOPathExpr));
        OOPathChunk secondChunk = (OOPathChunk)((OOPathExpr)expression).getChunks().get(2);
        BinaryExpr secondChunkFirstCondition = (BinaryExpr)secondChunk.getConditions().get(0);
        DrlNameExpr rightName = (DrlNameExpr)((FieldAccessExpr)secondChunkFirstCondition.getRight()).getScope();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)rightName.getBackReferencesCount());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testMapInitializationEmpty() {
        String expr = "countItems([])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testMapInitializationLiteralAsArgument() {
        String expr = "countItems([123 : 456, 789 : 1011])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
    }

    @Test
    public void testParseTemporalLiteral() {
        String expr = "5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)chunk0.getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk0.getTimeUnit()));
    }

    @Test
    public void testParseTemporalLiteralOf2Chunks() {
        String expr = "1m5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)drlx));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)chunk0.getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)chunk0.getTimeUnit()));
        TemporalLiteralChunkExpr chunk1 = (TemporalLiteralChunkExpr)drlx.getChunks().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)chunk1.getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk1.getTimeUnit()));
    }

    @Test
    public void testInExpression() {
        String expr = "this in ()";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof PointFreeExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testUnsupportedImplicitParameter() {
        String expr = "== \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression instanceof HalfBinaryExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testAndWithImplicitNegativeParameter() {
        String expr = "value > -2 && < -1";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)this.toString((Node)first.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-2", (Object)this.toString((Node)first.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-1", (Object)this.toString((Node)second.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
    }

    @Test
    public void testOrWithImplicitParameter() {
        String expr = "name == \"Mark\" || == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter() {
        String expr = "name == \"Mark\" && == \"Mario\" && == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter2() {
        String expr = "name == \"Mark\" && == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name", (Object)this.toString((Node)first.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Mark\"", (Object)this.toString((Node)first.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Mario\"", (Object)this.toString((Node)second.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"Luca\"", (Object)this.toString((Node)third.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter3() {
        String expr = "age == 2 && == 3 || == 4";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"age", (Object)this.toString((Node)first.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2", (Object)this.toString((Node)first.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3", (Object)this.toString((Node)second.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"4", (Object)this.toString((Node)third.getRight()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void dotFreeWithRegexp() {
        String expr = "name matches \"[a-z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(PointFreeExpr.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name matches \"[a-z]*\"", (Object)PrintUtil.printConstraint((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"matches", (Object)e.getOperator().asString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name", (Object)this.toString((Node)e.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"\"[a-z]*\"", (Object)this.toString(e.getRight().get(0)));
    }

    @Test
    public void implicitOperatorWithRegexps() {
        String expr = "name matches \"[a-z]*\" || matches \"pippo\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name matches \"[a-z]*\" || matches \"pippo\"", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void halfPointFreeExpr() {
        String expr = "matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(HalfPointFreeExpr.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"matches \"[A-Z]*\"", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void halfPointFreeExprNegated() {
        String expr = "not matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(HalfPointFreeExpr.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"not matches \"[A-Z]*\"", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void regressionTestHalfPointFree() {
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getAddress().getAddressName().length() == 5").getExpr()).isInstanceOf(BinaryExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isFortyYearsOld(this, true)").getExpr()).isInstanceOf(MethodCallExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getName().startsWith(\"M\")").getExpr()).isInstanceOf(MethodCallExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isPositive($i.intValue())").getExpr()).isInstanceOf(MethodCallExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"someEntity.someString in (\"1.500\")").getExpr()).isInstanceOf(PointFreeExpr.class);
    }

    @Test
    public void mvelSquareBracketsOperators() {
        this.testMvelSquareOperator("this str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", false);
        this.testMvelSquareOperator("this not str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", true);
        this.testMvelSquareOperator("this str[endsWith] \"K\"", "str[endsWith]", "this", "\"K\"", false);
        this.testMvelSquareOperator("this str[length] 17", "str[length]", "this", "17", false);
    }

    @Test
    public void halfPointFreeMVEL() {
        String expr = "this str[startsWith] \"M\" || str[startsWith] \"E\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"this str[startsWith] \"M\" || str[startsWith] \"E\"", (Object)PrintUtil.printConstraint((Node)expression));
        Expression expression2 = DrlxParser.parseExpression(this.parser, (String)"str[startsWith] \"E\"").getExpr();
        Assertions.assertThat((Object)expression2).isInstanceOf(HalfPointFreeExpr.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"str[startsWith] \"E\"", (Object)PrintUtil.printConstraint((Node)expression2));
    }

    @Test
    void testLambda() {
        String expr = "x -> y";
        DrlxExpression expression = DrlxParser.parseExpression(this.parser, (String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    void testLambdaParameter() {
        String expr = "($p).setCanDrinkLambda(() -> true)";
        DrlxExpression expression = DrlxParser.parseExpression(this.parser, (String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyStatement() {
        String expr = "{ modify ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    modify ($p) { name = \"Luca\", age = \"35\" };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyFailing() {
        org.junit.jupiter.api.Assertions.assertThrows(ParseProblemException.class, () -> {
            String expr = "{ modify  { name = \"Luca\", age = \"35\" }; }";
            MvelParser.parseBlock((String)expr);
        });
    }

    @Test
    public void testModifyStatementSemicolon() {
        String expr = "{ modify ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    modify ($p) { name = \"Luca\" };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifySemiColon() {
        String expr = "{ modify($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    modify ($p) { setAge(1) };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    void testModifyLambda() {
        String expr = "{  modify($p) {  setCanDrinkLambda(() -> true); } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\n    modify ($p) { setCanDrinkLambda(() -> true) };\n}", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyMultiple() {
        String expr = "{ modify($p) { setAge(1)," + System.lineSeparator() + " setAge(2);setAge(3)" + System.lineSeparator() + "setAge(4); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    modify ($p) { setAge(1), setAge(2), setAge(3), setAge(4) };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyEmptyBlock() {
        String expr = "{ modify( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    modify ($s) {  };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyWithoutSemicolon() {
        String expr = "{modify($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    modify ($p) { setAge($p.getAge() + 1) };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testModifyWithCast() {
        String expr = "{modify( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    modify ((BooleanEvent) $toEdit.get(0)) {  };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithStatement() {
        String expr = "{ with ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    with ($p) { name = \"Luca\", age = \"35\" };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithFailing() {
        org.junit.jupiter.api.Assertions.assertThrows(ParseProblemException.class, () -> {
            String expr = "{ with  { name = \"Luca\", age = \"35\" }; }";
            MvelParser.parseBlock((String)expr);
        });
    }

    @Test
    public void testWithStatementSemicolon() {
        String expr = "{ with ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    with ($p) { name = \"Luca\" };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithSemiColon() {
        String expr = "{ with($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    with ($p) { setAge(1) };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithEmptyBlock() {
        String expr = "{ with( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    with ($s) {  };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithWithoutSemicolon() {
        String expr = "{with($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    with ($p) { setAge($p.getAge() + 1) };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithWithCast() {
        String expr = "{with( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    with ((BooleanEvent) $toEdit.get(0)) {  };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithConstructor() {
        String expr = "{ with(s1 = new Some()) { }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    with (s1 = new Some()) {  };" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolon() {
        String expr = "{             a" + System.lineSeparator() + "b" + System.lineSeparator() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    a;" + System.lineSeparator() + "    b;" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethod() {
        String expr = "{             delete($person)" + System.lineSeparator() + "delete($pet)" + System.lineSeparator() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    delete($person);" + System.lineSeparator() + "    delete($pet);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethodComment() {
        String expr = "{             delete($person) // comment" + System.lineSeparator() + "delete($pet) // comment " + System.lineSeparator() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    delete($person);" + System.lineSeparator() + "    delete($pet);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testWithoutSemicolonMethodCommentOppositeOSLineEndings() {
        String oppositeLineEnding = this.isOsWindows() ? "\n" : "\r\n";
        String expr = "{             delete($person) // comment" + oppositeLineEnding + "delete($pet) // comment" + oppositeLineEnding + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    delete($person);" + System.lineSeparator() + "    delete($pet);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void statementsWithComments() {
        String expr = "{             delete($person); // comment" + System.lineSeparator() + "delete($pet); // comment " + System.lineSeparator() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    delete($person);" + System.lineSeparator() + "    delete($pet);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void singleLineBlock() {
        String expr = "{ delete($person); } // comment ";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    delete($person);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void singleLineBlockWithoutsemicolon() {
        String expr = "{ delete($person) } // comment";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    delete($person);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void commentsWithEmptyStatements() {
        String expr = "{// modify ; something" + System.lineSeparator() + "/* modify ; something */" + System.lineSeparator() + "setAge(47)" + System.lineSeparator() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    ;" + System.lineSeparator() + "    ;" + System.lineSeparator() + "    setAge(47);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void newLineInFunctionCall() {
        String expr = "{func(x " + System.lineSeparator() + ")" + System.lineSeparator() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    func(x);" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void newLineInFunctionCall2() {
        Expression expression = MvelParser.parseExpression((String)("func(x," + System.lineSeparator() + " 2)"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"func(x, 2)", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void newLineInFunctionCall3() {
        Expression expression = MvelParser.parseExpression((String)("func(x" + System.lineSeparator() + ", 2)"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"func(x, 2)", (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void commentsWithEmptyStatements2() {
        String expr = "{  globalA.add(\"A\");" + System.lineSeparator() + "  modify( $p ) {" + System.lineSeparator() + "    // modify ; something" + System.lineSeparator() + "    /* modify ; something */" + System.lineSeparator() + "    setAge(47)" + System.lineSeparator() + "  }" + System.lineSeparator() + "  globalB.add(\"B\");" + System.lineSeparator() + "  // modify ; something" + System.lineSeparator() + "  /* modify ; something */}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("{" + System.lineSeparator() + "    globalA.add(\"A\");" + System.lineSeparator() + "    modify ($p) { setAge(47) };" + System.lineSeparator() + "    globalB.add(\"B\");" + System.lineSeparator() + "}"), (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testNewExpression() {
        String expr = "money == new BigInteger(\"3\")";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testArrayCreation() {
        String expr = "new Object[] { \"getMessageId\", ($s != null ? $s : \"42103\") }";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    @Test
    public void testArrayCreation2() {
        String expr = "functions.arrayContainsInstanceWithParameters((Object[]) $f.getPersons())";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr, (Object)PrintUtil.printConstraint((Node)expression));
    }

    private void testMvelSquareOperator(String wholeExpression, String operator, String left, String right, boolean isNegated) {
        String expr = wholeExpression;
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(PointFreeExpr.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)wholeExpression, (Object)PrintUtil.printConstraint((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        org.junit.jupiter.api.Assertions.assertEquals((Object)operator, (Object)e.getOperator().asString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)left, (Object)this.toString((Node)e.getLeft()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)right, (Object)this.toString(e.getRight().get(0)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)isNegated, (Object)e.isNegated());
    }

    private String toString(Node n) {
        return PrintUtil.printConstraint((Node)n);
    }

    private boolean isOsWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.trim().toLowerCase().contains("windows");
    }
}

