/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.DockerComposeContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class GrafanaDockerComposeIT {
    private static final String GRAFANA_URL = "http://localhost:3000";
    private static final String PROMETHEUS_PRIVATE_URL = "http://prometheus:9090";
    @Container
    public static DockerComposeContainer environment = new DockerComposeContainer(new File[]{new File("./docker-compose.yml")}).withExposedService("grafana_1", 3000, (WaitStrategy)Wait.forHttp((String)"/").forStatusCode(200));

    @Test
    public void testPrometheusDataSource() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(GRAFANA_URL).contentType(ContentType.JSON).when().get("/api/datasources", new Object[0])).then()).statusCode(200)).body("type", Matchers.hasItem((Object)"prometheus"), new Object[0])).body("url", Matchers.hasItem((Object)PROMETHEUS_PRIVATE_URL), new Object[0]);
    }

    @Test
    public void testGrafanaDashboards() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(GRAFANA_URL).contentType(ContentType.JSON).when().get("/api/search", new Object[0])).then()).statusCode(200)).body("title", Matchers.hasItem((Object)"hello - Operational Dashboard"), new Object[0])).body("title", Matchers.hasItem((Object)"LoanEligibility - Domain Dashboard"), new Object[0])).body("title", Matchers.hasItem((Object)"LoanEligibility - Operational Dashboard"), new Object[0]);
    }
}

