/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.net.URISyntaxException;
import java.time.Duration;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testcontainers.containers.DockerComposeContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class GrafanaDockerComposeIT {
    private static final String GRAFANA_URL = "http://localhost:3000";
    private static final String PROMETHEUS_PRIVATE_URL = "http://prometheus:9090";
    private static final String KOGITO_APPLICATION_URL = "http://localhost:8080";
    @Container
    public static DockerComposeContainer environment;

    @BeforeAll
    void setup() {
        environment.start();
    }

    @Test
    public void testPrometheusDataSource() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(GRAFANA_URL).contentType(ContentType.JSON).when().get("/api/datasources", new Object[0])).then()).statusCode(200)).body("type", Matchers.hasItem((Object)"prometheus"), new Object[0])).body("url", Matchers.hasItem((Object)PROMETHEUS_PRIVATE_URL), new Object[0]);
    }

    @Test
    public void testGrafanaDashboards() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(GRAFANA_URL).contentType(ContentType.JSON).when().get("/api/search", new Object[0])).then()).statusCode(200)).body("title", Matchers.hasItem((Object)"hello - Operational Dashboard"), new Object[0])).body("title", Matchers.hasItem((Object)"LoanEligibility - Domain Dashboard"), new Object[0])).body("title", Matchers.hasItem((Object)"LoanEligibility - Operational Dashboard"), new Object[0]);
    }

    @Test
    public void testKogitoContainerIsDeployedAndResponsive() {
        String body = "{\"Client\": {\"age\": 43,\"salary\": 1950, \"existing payments\": 100}, \"Loan\": {\"duration\": 15,\"installment\": 180}, \"SupremeDirector\" : \"Yes\", \"Bribe\": 1000}";
        ((ValidatableResponse)((Response)RestAssured.given().baseUri(KOGITO_APPLICATION_URL).contentType(ContentType.JSON).when().body(body).post("/LoanEligibility", new Object[0])).then()).statusCode(200);
    }

    static {
        try {
            environment = new DockerComposeContainer(new File[]{new File(GrafanaDockerComposeIT.class.getClassLoader().getResource("./docker-compose.yml").toURI())}).withExposedService("grafana_1", 3000, Wait.forListeningPort().withStartupTimeout(Duration.ofMinutes(8L)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

