/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.drools.core.event.DefaultAgendaEventListener;
import org.jboss.logging.Logger;
import org.kie.api.event.KieRuntimeEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;

public class CustomRuleEventListener
extends DefaultAgendaEventListener {
    private static final Logger logger = Logger.getLogger(CustomRuleEventListener.class);
    private final PrometheusMeterRegistry prometheusMeterRegistry;

    public CustomRuleEventListener(PrometheusMeterRegistry prometheusMeterRegistry) {
        this.prometheusMeterRegistry = prometheusMeterRegistry;
    }

    public void matchCreated(MatchCreatedEvent event) {
        super.matchCreated(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void matchCancelled(MatchCancelledEvent event) {
        super.matchCancelled(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void beforeMatchFired(BeforeMatchFiredEvent event) {
        super.beforeMatchFired(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
        super.afterMatchFired(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
        super.agendaGroupPopped(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
        super.agendaGroupPushed(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        super.beforeRuleFlowGroupActivated(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        super.afterRuleFlowGroupActivated(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        super.beforeRuleFlowGroupDeactivated(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        super.afterRuleFlowGroupDeactivated(event);
        this.registerEvent((KieRuntimeEvent)event);
    }

    private void registerEvent(KieRuntimeEvent event) {
        logger.debug((Object)event.getClass().getSimpleName());
        this.prometheusMeterRegistry.counter("org.kie.kogito.examples.customruleeventlistener", new String[]{"event", event.getClass().getSimpleName().toLowerCase()}).increment();
    }
}

