/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class LoanEligibilityTest {
    @Test
    public void testEvaluateLoanEligibility() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"Client\": {\"age\": 43,\"salary\": 1950,\"existing payments\": 100},\"Loan\": {\"duration\": 15,\"installment\": 180}, \"SupremeDirector\" : \"Yes\", \"Bribe\": 1000}").contentType(ContentType.JSON).when().post("/LoanEligibility", new Object[0])).then()).statusCode(200)).body("'Decide'", Matchers.is((Object)true), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"Client\": {\"age\": 43,\"salary\": 1950,\"existing payments\": 100},\"Loan\": {\"duration\": 15,\"installment\": 180}, \"SupremeDirector\" : \"No\", \"Bribe\": 0}").contentType(ContentType.JSON).when().post("/LoanEligibility", new Object[0])).then()).statusCode(200)).body("'Decide'", Matchers.is((Object)false), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/metrics", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"string_dmn_result_total{decision=\"Eligibility\",endpoint=\"LoanEligibility\",identifier=\"Yes\",} 2.0"), new Matcher[0])).body(Matchers.containsString((String)"string_dmn_result_total{decision=\"Judgement\",endpoint=\"LoanEligibility\",identifier=\"Yes\",} 1.0"), new Matcher[0])).body(Matchers.containsString((String)"string_dmn_result_total{decision=\"Judgement\",endpoint=\"LoanEligibility\",identifier=\"No\",} 1.0"), new Matcher[0])).body(Matchers.containsString((String)"boolean_dmn_result_total{decision=\"Decide\",endpoint=\"LoanEligibility\",identifier=\"true\",} 1.0"), new Matcher[0])).body(Matchers.containsString((String)"boolean_dmn_result_total{decision=\"Decide\",endpoint=\"LoanEligibility\",identifier=\"false\",} 1.0\n"), new Matcher[0])).body(Matchers.containsString((String)"number_dmn_result{decision=\"Is Enough?\",endpoint=\"LoanEligibility\",quantile=\"0.5\",} 0.0"), new Matcher[0])).body(Matchers.containsString((String)"number_dmn_result_count{decision=\"Is Enough?\",endpoint=\"LoanEligibility\",} 2.0"), new Matcher[0])).body(Matchers.containsString((String)"number_dmn_result_sum{decision=\"Is Enough?\",endpoint=\"LoanEligibility\",} 100.0"), new Matcher[0])).body(Matchers.containsString((String)"number_dmn_result{decision=\"Is Enough?\",endpoint=\"LoanEligibility\",quantile=\"0.75\",} 100.0"), new Matcher[0])).body(Matchers.containsString((String)"number_dmn_result_max{decision=\"Is Enough?\",endpoint=\"LoanEligibility\",} 100.0"), new Matcher[0]);
    }

    @Test
    public void testDashboardsListIsAvailable() {
        List dashboards = (List)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/monitoring/dashboards/list.json", new Object[0])).as(List.class);
        Assertions.assertEquals((int)4, (int)dashboards.size());
    }
}

