/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.function.Consumer;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.kie.kogito.testcontainers.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.DockerComposeContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class GrafanaDockerComposeIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrafanaDockerComposeIT.class);
    private static final Duration STARTUP_MINUTES_TIMEOUT = Constants.CONTAINER_START_TIMEOUT;
    private static final int GRAFANA_PORT = 3000;
    private static final int PROMETHEUS_PORT = 9090;
    private static final int KOGITO_APPLICATION_PORT = 8080;
    private static final String GRAFANA_URL = "http://localhost:3000";
    private static final String PROMETHEUS_PRIVATE_URL = "http://prometheus:9090";
    private static final String PROMETHEUS_PUBLIC_URL = "http://localhost:9090";
    private static final String KOGITO_APPLICATION_URL = "http://localhost:8080";
    @Container
    public static DockerComposeContainer environment;

    @BeforeAll
    void setup() {
        environment.start();
    }

    @AfterAll
    void cleanup() {
        environment.stop();
    }

    @Test
    public void testPrometheusDataSource() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(GRAFANA_URL).contentType(ContentType.JSON).when().get("/api/datasources", new Object[0])).then()).statusCode(200)).body("type", Matchers.hasItem((Object)"prometheus"), new Object[0])).body("url", Matchers.hasItem((Object)PROMETHEUS_PRIVATE_URL), new Object[0]);
    }

    @Test
    @Disabled
    public void testGrafanaDashboards() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(GRAFANA_URL).contentType(ContentType.JSON).when().get("/api/search", new Object[0])).then()).statusCode(200)).body("title", Matchers.hasItem((Object)"dmn-drools-quarkus-metrics:1.7.0-SNAPSHOT - hello - Operational Dashboard"), new Object[0])).body("title", Matchers.hasItem((Object)"dmn-drools-quarkus-metrics:1.7.0-SNAPSHOT - LoanEligibility - Domain Dashboard"), new Object[0])).body("title", Matchers.hasItem((Object)"dmn-drools-quarkus-metrics:1.7.0-SNAPSHOT - Hello - Domain Dashboard"), new Object[0])).body("title", Matchers.hasItem((Object)"dmn-drools-quarkus-metrics:1.7.0-SNAPSHOT - LoanEligibility - Operational Dashboard"), new Object[0]);
    }

    @Test
    public void testKogitoContainerIsDeployedAndResponsive() {
        String body = "{\"Client\": {\"age\": 43,\"salary\": 1950, \"existing payments\": 100}, \"Loan\": {\"duration\": 15,\"installment\": 180}, \"SupremeDirector\" : \"Yes\", \"Bribe\": 1000}";
        ((ValidatableResponse)((Response)RestAssured.given().baseUri(KOGITO_APPLICATION_URL).contentType(ContentType.JSON).when().body(body).post("/LoanEligibility", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void testMetricsContentTypeHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().baseUri(KOGITO_APPLICATION_URL).when().get("/metrics", new Object[0])).then()).header("Content-Type", "text/plain;charset=UTF-8");
    }

    static {
        try {
            environment = new DockerComposeContainer(new File[]{new File(GrafanaDockerComposeIT.class.getClassLoader().getResource("./docker-compose.yml").toURI())}).withExposedService("grafana_1", 3000, Wait.forListeningPort().withStartupTimeout(STARTUP_MINUTES_TIMEOUT)).withLogConsumer("grafana_1", (Consumer)new Slf4jLogConsumer(LOGGER)).withExposedService("hello_1", 8080, Wait.forListeningPort().withStartupTimeout(STARTUP_MINUTES_TIMEOUT)).withLogConsumer("hello_1", (Consumer)new Slf4jLogConsumer(LOGGER)).withExposedService("prometheus_1", 9090, Wait.forHttp((String)"/api/v1/targets").forResponsePredicate(x -> x.contains("\"health\":\"up\"")).withStartupTimeout(STARTUP_MINUTES_TIMEOUT)).withLogConsumer("prometheus_1", (Consumer)new Slf4jLogConsumer(LOGGER));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

