/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.kogito.examples.ProjectMetadataProvider;

@QuarkusTest
public class LoanEligibilityTest {
    private static final String PROJECT_VERSION = ProjectMetadataProvider.getProjectVersion();
    private static final String PROJECT_ARTIFACT_ID = ProjectMetadataProvider.getProjectArtifactId();

    @Test
    @Disabled(value="Uses 2.0.0-SNAPSHOT in 1.8.0-SNAPSHOT")
    public void testEvaluateLoanEligibility() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"Client\": {\"age\": 43,\"salary\": 1950,\"existing payments\": 100},\"Loan\": {\"duration\": 15,\"installment\": 180}, \"SupremeDirector\" : \"Yes\", \"Bribe\": 1000}").contentType(ContentType.JSON).when().post("/LoanEligibility", new Object[0])).then()).statusCode(200)).body("'Decide'", Matchers.is((Object)true), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"Client\": {\"age\": 43,\"salary\": 1950,\"existing payments\": 100},\"Loan\": {\"duration\": 15,\"installment\": 180}, \"SupremeDirector\" : \"No\", \"Bribe\": 0}").contentType(ContentType.JSON).when().post("/LoanEligibility", new Object[0])).then()).statusCode(200)).body("'Decide'", Matchers.is((Object)false), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/metrics", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)String.format("string_dmn_result_total{artifactId=\"%s\",decision=\"Eligibility\",endpoint=\"LoanEligibility\",identifier=\"Yes\",version=\"%s\",} 2.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("string_dmn_result_total{artifactId=\"%s\",decision=\"Judgement\",endpoint=\"LoanEligibility\",identifier=\"Yes\",version=\"%s\",} 1.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("string_dmn_result_total{artifactId=\"%s\",decision=\"Judgement\",endpoint=\"LoanEligibility\",identifier=\"No\",version=\"%s\",} 1.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("boolean_dmn_result_total{artifactId=\"%s\",decision=\"Decide\",endpoint=\"LoanEligibility\",identifier=\"true\",version=\"%s\",} 1.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("boolean_dmn_result_total{artifactId=\"%s\",decision=\"Decide\",endpoint=\"LoanEligibility\",identifier=\"false\",version=\"%s\",} 1.0\n", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("number_dmn_result{artifactId=\"%s\",decision=\"Is Enough?\",endpoint=\"LoanEligibility\",version=\"%s\",quantile=\"0.5\",} 0.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("number_dmn_result_max{artifactId=\"%s\",decision=\"Is Enough?\",endpoint=\"LoanEligibility\",version=\"%s\",} 100.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("number_dmn_result_count{artifactId=\"%s\",decision=\"Is Enough?\",endpoint=\"LoanEligibility\",version=\"%s\",} 2.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("number_dmn_result_sum{artifactId=\"%s\",decision=\"Is Enough?\",endpoint=\"LoanEligibility\",version=\"%s\",} 100.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("number_dmn_result{artifactId=\"%s\",decision=\"Is Enough?\",endpoint=\"LoanEligibility\",version=\"%s\",quantile=\"0.75\",} 100.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("api_execution_elapsed_seconds{artifactId=\"%s\",endpoint=\"LoanEligibility\",version=\"%s\",quantile=\"0.5\",}", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("api_http_response_code_total{artifactId=\"%s\",endpoint=\"LoanEligibility\",identifier=\"200\",version=\"%s\",} 2.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0])).body(Matchers.containsString((String)String.format("api_execution_elapsed_seconds_count{artifactId=\"%s\",endpoint=\"LoanEligibility\",version=\"%s\",} 2.0", PROJECT_ARTIFACT_ID, PROJECT_VERSION)), new Matcher[0]);
    }

    @Test
    public void testDashboardsListIsAvailable() {
        List dashboards = (List)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/monitoring/dashboards/list.json", new Object[0])).as(List.class);
        Assertions.assertEquals((int)4, (int)dashboards.size());
    }
}

