/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.event.ChannelType;
import org.kie.kogito.event.CloudEventMeta;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.Topic;

@QuarkusTest
public class TopicsInformationTest {
    @Test
    void verifyTopicsInformation() {
        Topic expectedIncomingTopic = new Topic("kogito_incoming_stream", ChannelType.INCOMING);
        expectedIncomingTopic.setEventsMeta(Collections.singletonList(new CloudEventMeta("DecisionRequest", "", EventKind.CONSUMED)));
        HashSet<CloudEventMeta> expectedOutgoingEventMeta = new HashSet<CloudEventMeta>();
        expectedOutgoingEventMeta.add(new CloudEventMeta("DecisionResponse", "Traffic+Violation", EventKind.PRODUCED));
        expectedOutgoingEventMeta.add(new CloudEventMeta("DecisionResponse", "Traffic+Violation/FineService", EventKind.PRODUCED));
        expectedOutgoingEventMeta.add(new CloudEventMeta("DecisionResponseFull", "Traffic+Violation", EventKind.PRODUCED));
        expectedOutgoingEventMeta.add(new CloudEventMeta("DecisionResponseFull", "Traffic+Violation/FineService", EventKind.PRODUCED));
        expectedOutgoingEventMeta.add(new CloudEventMeta("DecisionResponseError", "Traffic+Violation", EventKind.PRODUCED));
        expectedOutgoingEventMeta.add(new CloudEventMeta("DecisionResponseError", "Traffic+Violation/FineService", EventKind.PRODUCED));
        expectedOutgoingEventMeta.add(new CloudEventMeta("DecisionResponseError", "__UNKNOWN_SOURCE__", EventKind.PRODUCED));
        Topic expectedOutgoingTopic = new Topic("kogito_outgoing_stream", ChannelType.OUTGOING);
        expectedOutgoingTopic.setEventsMeta(expectedOutgoingEventMeta);
        List<Topic> topics = Arrays.asList((Topic[])((Response)RestAssured.given().get("/messaging/topics", new Object[0])).as(Topic[].class));
        MatcherAssert.assertThat(topics, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat(topics, (Matcher)CoreMatchers.hasItem((Object)expectedIncomingTopic));
        MatcherAssert.assertThat(topics, (Matcher)CoreMatchers.hasItem((Object)expectedOutgoingTopic));
    }
}

