/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class CloudEventListenerTest {
    private static final String KOGITO_MODEL_NAME = "Traffic Violation";
    private static final String KOGITO_MODEL_NAMESPACE = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
    private static WireMockServer sink;

    @BeforeAll
    public static void startSink() {
        sink = new WireMockServer((Options)WireMockConfiguration.options().port(8181));
        sink.start();
        sink.stubFor(WireMock.post((String)"/").willReturn(WireMock.aResponse().withBody("ok").withStatus(200)));
    }

    @AfterAll
    public static void stopSink() {
        if (sink != null) {
            sink.stop();
        }
    }

    @Test
    void checkDecision() throws JsonProcessingException {
        Map<String, Map<String, Integer>> decisionInput = Map.of("Driver", Map.of("Age", 35, "Points", 3), "Violation", Map.of("Type", "speed", "Actual Speed", 115, "Speed Limit", 100));
        ((ValidatableResponse)((Response)RestAssured.given().header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)"000", new Object[0]).header("ce-source", (Object)"/from/test", new Object[0]).header("ce-type", (Object)"DecisionRequest", new Object[0]).header("ce-kogitodmnmodelname", (Object)KOGITO_MODEL_NAME, new Object[0]).header("ce-kogitodmnmodelnamespace", (Object)KOGITO_MODEL_NAMESPACE, new Object[0]).contentType("application/json").body(new ObjectMapper().writeValueAsString(decisionInput)).post("/", new Object[0])).then()).statusCode(200);
        Awaitility.await().atLeast(2L, TimeUnit.SECONDS).atMost(10L, TimeUnit.SECONDS).with().pollInterval(2L, TimeUnit.SECONDS).untilAsserted(() -> sink.verify(1, WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.specversion", (StringValuePattern)new EqualToPattern("1.0"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.source", (StringValuePattern)new EqualToPattern(KOGITO_MODEL_NAME.replace(" ", "+")))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.type", (StringValuePattern)new EqualToPattern("DecisionResponse"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.kogitodmnmodelnamespace", (StringValuePattern)new EqualToPattern(KOGITO_MODEL_NAMESPACE))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.kogitodmnmodelname", (StringValuePattern)new EqualToPattern(KOGITO_MODEL_NAME)))));
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

