/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmnpmml.kogito.springboot.example;

import io.restassured.RestAssured;
import io.restassured.config.JsonConfig;
import io.restassured.http.ContentType;
import io.restassured.path.json.config.JsonPathConfig;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.dmnpmml.kogito.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class DMNScoreCardTest {
    @LocalServerPort
    private int port;

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    public void testEvaluateScoreCardDMN() {
        String inputData = "{\"age\": 23.0, \"occupation\": \"SKYDIVER\", \"residenceState\": \"AP\", \"validLicense\": true}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssured.config().jsonConfig(JsonConfig.jsonConfig().numberReturnType(JsonPathConfig.NumberReturnType.DOUBLE))).contentType(ContentType.JSON).body(inputData).when().post("/TestScoreCardDMN", new Object[0])).then()).statusCode(200)).body("ScoreCardBKM", Matchers.is((Object)"function ScoreCardBKM( age, occupation, residenceState, validLicense )"), new Object[0])).body("age", Matchers.is((Matcher)Matchers.comparesEqualTo((Comparable)Integer.valueOf(23))), new Object[0])).body("occupation", Matchers.is((Matcher)Matchers.comparesEqualTo((Comparable)((Object)"SKYDIVER"))), new Object[0])).body("residenceState", Matchers.is((Matcher)Matchers.comparesEqualTo((Comparable)((Object)"AP"))), new Object[0])).body("validLicense", Matchers.is((Matcher)Matchers.comparesEqualTo((Comparable)Boolean.valueOf(true))), new Object[0])).body("Score", Matchers.is((Matcher)Matchers.comparesEqualTo((Comparable)Double.valueOf(21.345))), new Object[0]);
    }
}

