package testminingmodelsummed.miningmodelsum;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;

public class MiningModelSum extends KiePMMLMiningModel {

    public MiningModelSum() {
        super("MiningModelSum", Collections.emptyList());
        targetField = "result";
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.MINING_MODEL;
        segmentation = new testminingmodelsummed.miningmodelsum.miningmodelsumsegmentation.MiningModelSumSegmentation();
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLOutputFields = this.getCreatedKiePMMLOutputFields();
        miningFields.add(new org.kie.pmml.api.models.MiningField("input1", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("input2", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("input3", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("result", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.TARGET, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("result", null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, "result", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList()));
    }

    private List<KiePMMLOutputField> getCreatedKiePMMLOutputFields() {
        KiePMMLOutputField result = KiePMMLOutputField.builder("result", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).withTargetField("result").withValue(null).withRank(1).withKiePMMLExpression(null).build();
        return Arrays.asList(result);
    }
}
