/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn.pmml.springboot.example;

import io.restassured.RestAssured;
import java.util.HashMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.dmn.pmml.springboot.example.CommonTestUtils;
import org.kie.kogito.dmn.pmml.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class DecisionTreeTest {
    private static final String BASE_PATH = "/DecisionTree";
    private static final String TARGET = "decision";
    @LocalServerPort
    private int port;

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    void testEvaluateDecisionTreeResult() {
        String inputData = "{\"temperature\":30.0, \"humidity\":10.0}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, "sunglasses");
    }

    @Test
    void testEvaluateDecisionTreeDescriptive() {
        String inputData = "{\"temperature\":30.0, \"humidity\":10.0}";
        HashMap<String, Object> expectedResultMap = new HashMap<String, Object>();
        expectedResultMap.put(TARGET, "sunglasses");
        expectedResultMap.put("weatherdecision", "sunglasses");
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }
}

